<?php

	function isPost(...$funcArgs){
		$flag = true;

		for($i = 0; $i < count($funcArgs); $i++){
			if(!isset($_POST[$funcArgs[$i]])){
				$flag = false; break;
			}
		}

		return $flag;
	}


/*
|--------------------------------------------------------------------------
| Class Report
|--------------------------------------------------------------------------
*/
class Report{

	public static function getCustomerName($poID, $doNumber, $invoiceSymbol){
		global $con;
		$customerDetails 	= array();
		
		if($invoiceSymbol == 'S'){
			$tableName 		= 'purchase_order_master';
			$primaryKey 	= 'purchaseID';
			$poNumberKey 	= 'purch_custm_po_num';
			$poDatekey 		= 'purch_po_date';

			$qEx = mysqli_query($con, "SELECT * FROM delivery_order_master WHERE dely_od_dopo = '$doNumber' ")->fetch_object();
			if($qEx){
				$customerDetails['doNumber'] 	= $qEx->dely_od_dopo;
				$customerDetails['doDate'] 		= $qEx->dely_od_date;
			}

		} else if($invoiceSymbol == 'G'){
			$tableName 		= 'purchase_order_goods';
			$primaryKey 	= 'purgds_id';
			$poNumberKey 	= 'purgds_custm_po';
			$poDatekey 		= 'purgds_podate';
			$customerDetails['doNumber'] 	= '';
			$customerDetails['doDate'] 		= '';
		
		} else {
			return 0;
		}

		$qEx = mysqli_query($con, "SELECT * FROM $tableName WHERE $primaryKey = $poID ");
		
		$fetchedPO 			= $qEx->fetch_object();
		$customerID 		= $fetchedPO->customerID;
		$fetchedCustomer 	= mysqli_query($con, "SELECT * FROM customer_master WHERE custmID = $customerID ")->fetch_object();

		$customerDetails['poNumber'] 		= $fetchedPO->$poNumberKey;
		$customerDetails['poDate'] 			= $fetchedPO->$poDatekey;
		$customerDetails['customerName']	= $fetchedCustomer->custm_name;
		$customerDetails['customerGST']		= $fetchedCustomer->custm_gst_no;

		return $customerDetails;
	}

	public static function getPartDetails($partID){
		global $con;
		$partDetails 				= array();
		$qEx 						= mysqli_query($con, "SELECT * FROM part_master WHERE part_id = $partID ");
		$fetchedPart 				= $qEx->fetch_object();
		if($fetchedPart){
			$partDetails['partNumber'] 	= $fetchedPart->part_no;
			$partDetails['partName'] 	= $fetchedPart->part_name;
			$partDetails['partHSN'] 	= $fetchedPart->part_hsn_no;
			return $partDetails;
		}
	}

	public static function listInvoiceByDateRange($fromDate, $toDate){
		global $con;
		$a = mysqli_query($con, "SELECT * FROM invoices_report WHERE STR_TO_DATE(report_invcdate, '%d/%m/%Y') BETWEEN STR_TO_DATE('$fromDate', '%d/%m/%Y') AND STR_TO_DATE('$toDate', '%d/%m/%Y') ORDER BY STR_TO_DATE(report_invcdate, '%d/%m/%Y') , report_invcno ASC ");
		
		$reportList = [];

		while($row = mysqli_fetch_assoc($a)){
			$reportList[] = $row;
		}
		return $reportList;
	}

	public static function summaryReport($invoiceList){
		$summaryReport = [];
		for($i = 0; $i < count($invoiceList); $i++){
			$eachInvoice = $invoiceList[$i];

			if($eachInvoice['part5ID'] > 0){
				$totalParts = 5;
			} else if($eachInvoice['part4ID'] > 0) {
				$totalParts = 4;
			} else if($eachInvoice['part3ID'] > 0) {
				$totalParts = 3;
			} else if($eachInvoice['part2ID'] > 0) {
				$totalParts = 2;
			} else if($eachInvoice['part1ID'] > 0) {
				$totalParts = 1;
			}
			for($j = 1; $j <= $totalParts; $j++){
				if($eachInvoice['poID'] == 0 || ($eachInvoice['report_symbol'] == 'S' && !$eachInvoice['report_do'])){
					continue;
				}
				
				$customerDetails 	= self::getCustomerName($eachInvoice['poID'], $eachInvoice['report_do'], $eachInvoice['report_symbol']);
				$partDetails 		= self::getPartDetails($eachInvoice['part'.$j.'ID']);
				if(!$partDetails){
					continue;
				}
				$newReport 				= array();
				$newReport['DATE'] 		= $eachInvoice['report_invcdate'];
				$newReport['CUSTOMER'] 	= $customerDetails['customerName'];
				$newReport['INV NO'] 	= $eachInvoice['report_invcno'];
				$newReport['S/G'] 		= $eachInvoice['report_symbol'];
				$newReport['GSTIN'] 	= $customerDetails['customerGST'];
				$newReport['PO NO'] 	= $customerDetails['poNumber'];
				$newReport['DO NO'] 	= $customerDetails['doNumber'];
				$newReport['DO DATE'] 	= $customerDetails['doDate'];
				$newReport['PART NO'] 	= $partDetails['partNumber'];
				$newReport['HSN NO'] 	= $partDetails['partHSN'];
				$newReport['MATERIAL'] 	= $partDetails['partName'];
				$newReport['QTY'] 		= $eachInvoice['part'.$j.'_qty'];
				$newReport['RATE'] 		= $eachInvoice['part'.$j.'Price'];
				
				if($j == 1){
					$newReport['BASIC VAL'] = $eachInvoice['report_basicval'];
					$newReport['OP CGST'] 	= $eachInvoice['report_cgst'];
					$newReport['OP SGST'] 	= $eachInvoice['report_sgst'];
					$newReport['OP IGST'] 	= $eachInvoice['report_igst'];
					$newReport['INV VAL'] 	= $eachInvoice['report_invtot'];
				} else {
					$newReport['BASIC VAL'] = '';
					$newReport['OP CGST'] 	= '';
					$newReport['OP SGST'] 	= '';
					$newReport['OP IGST'] 	= '';
					$newReport['INV VAL'] 	= '';
				}

				$summaryReport[]		= $newReport;
			}
		}
		return $summaryReport;
	}

	public static function dcReport($dcList){
        $dcReport = [];
        for($i = 0; $i < count($dcList); $i++){
            $eachDC = $dcList[$i];

            if($eachDC['part5ID'] > 0){
                $totalParts = 5;
            } else if($eachDC['part4ID'] > 0) {
                $totalParts = 4;
            } else if($eachDC['part3ID'] > 0) {
                $totalParts = 3;
            } else if($eachDC['part2ID'] > 0) {
                $totalParts = 2;
            } else if($eachDC['part1ID'] > 0) {
                $totalParts = 1;
            }
            for($j = 1; $j <= $totalParts; $j++){
                if($eachDC['poID'] == 0 || !$eachDC['doNumber']){
                    continue;
                }
                
                $customerDetails    = self::getCustomerName($eachDC['poID'], $eachDC['doNumber'], 'S');
                $partDetails        = self::getPartDetails($eachDC['part'.$j.'ID']);
                if(!$partDetails){
                    continue;
                }
                $newReport              = array();
                $newReport['DATE']      = date('d/m/Y', strtotime($eachDC['date']));
                $newReport['CUSTOMER']  = $customerDetails['customerName'];
                $newReport['DC NO']     = $eachDC['rejectionID'];
                $newReport['GSTIN']     = $customerDetails['customerGST'];
                $newReport['PO NO']     = $customerDetails['poNumber'];
                $newReport['DO NO']     = $customerDetails['doNumber'];
                $newReport['DO DATE']   = $customerDetails['doDate'];
                $newReport['PART NO']   = $partDetails['partNumber'];
                $newReport['HSN NO']    = $partDetails['partHSN'];
                $newReport['MATERIAL']  = $partDetails['partName'];
                $newReport['QTY']       = $eachDC['part'.$j.'_qty'];

                $dcReport[]        = $newReport;
            }
        }
        return $dcReport;
    }

    public static function listDCByDateRange($fromDate, $toDate){
        global $con;
        $a = mysqli_query($con, "SELECT * FROM rejection_report WHERE date BETWEEN STR_TO_DATE('$fromDate', '%d/%m/%Y') AND STR_TO_DATE('$toDate', '%d/%m/%Y') ORDER BY date ASC ");
        
        $reportList = [];

        while($row = mysqli_fetch_assoc($a)){
            $reportList[] = $row;
        }
        return $reportList;
    }

}

?>