<?php

class DoReport{

	public $reportList;
	public $dcReport;
	public $conn;

	public function generateReport(){
		global $con;
		$this->conn = $con;
		$this->openedDOList();
		$this->filterReport();
		$this->exportReport();
	}

	private function openedDOList(){
		$a = mysqli_query($this->conn, "SELECT * FROM delivery_order_master WHERE qtyOnStart > 0 AND dely_od_qty > 0 ORDER BY  poID ASC, dely_od_dopo ASC ");
		
		$reportList = [];

		while($row = mysqli_fetch_assoc($a)){
			$reportList[] = $row;
		}
		$this->reportList = $reportList;
	}

	private function filterReport(){
		$reportList = $this->reportList;
	    $dcReport 	= [];

		for($i = 0; $i < count($reportList); $i++){
			$thisItem 				= [];
			$thisItem['Customer'] 	= self::customerName($reportList[$i]['poID']);
			$thisItem['PartNumber'] = self::partNumber($reportList[$i]['partID']);
			$thisItem['PartName'] 	= self::partName($reportList[$i]['partID']);
			$thisItem['DONumber'] 	= $reportList[$i]['dely_od_dopo'];
			$thisItem['DODate'] 	= $reportList[$i]['dely_od_date'];
			$thisItem['PONumber'] 	= self::poNumber($reportList[$i]['poID']);
			$thisItem['PODate'] 	= self::poDate($reportList[$i]['poID']);
			$thisItem['OpenQty'] 	= $reportList[$i]['dely_od_qty'];

			$dcReport[] = $thisItem;
		}

		$this->dcReport = $dcReport;
	}

	public function exportReport(){
	    $columnTitles = ['CUSTOMER', 'PART NO', 'PART NAME', 'DO NO', 'DO DATE', 'PO NO', 'PO DATE', 'OPEN QTY'];
		$objPHPExcel 	= new PHPExcel();

		$objPHPExcel->getProperties()->setCreator("Me")->setLastModifiedBy("Me")
			->setTitle("My Excel Sheet")->setSubject("My Excel Sheet")->setDescription("Excel Sheet")
			->setKeywords("Excel Sheet")->setCategory("Me");



	    $fileName 	= 'DO_Report_'.time();

	    $objPHPExcel->setActiveSheetIndex(0);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(45);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
		
		$rowCount 		= 1;
		$columnAlpha 	= 'A';
		for($i = 0; $i < count($columnTitles); $i++, $columnAlpha++){
			$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.$rowCount, $columnTitles[$i]);
		}
		$rowCount++;

		$dcReport = $this->dcReport;
		for($i = 0; $i < count($dcReport); $i++, $rowCount++){
			
			$columnAlpha = 'A';
			foreach($dcReport[$i] as $key => $value){
				$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.$rowCount, $value);
				$columnAlpha++;
			}
		}

		$objPHPExcel->getActiveSheet()->setTitle($fileName);

		//OTHER PROCESS
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		
		$outputType = false;

		if($outputType){
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="' . $fileName . '.xlsx"');
			header('Cache-Control: max-age=0');
			$objWriter->save('php://output');
		} else {
			$objWriter->save('files/do-report/' . $fileName . '.xlsx');
			$output =  ("<a href='files/do-report/". $fileName .".xlsx'>Open Your Excel Document</a>");
			echo $output;
		}

	}

	public function customerName($poID){
		$a 			= mysqli_query($this->conn, "SELECT * FROM purchase_order_master WHERE purchaseID = $poID ");
		$row 		= mysqli_fetch_assoc($a);
		$customerID = $row['customerID'];

		$b 			= mysqli_query($this->conn, "SELECT * FROM customer_master WHERE custmID = $customerID ");
		$row 		= mysqli_fetch_assoc($b);
		return $row['custm_name'];
	}

	public function partNumber($partID){
		$a 			= mysqli_query($this->conn, "SELECT * FROM part_master WHERE part_id = $partID ");
		$row 		= mysqli_fetch_assoc($a);
		return $row['part_no'];
	}

	public function partName($partID){
		$a 			= mysqli_query($this->conn, "SELECT * FROM part_master WHERE part_id = $partID ");
		$row 		= mysqli_fetch_assoc($a);
		return $row['part_name'];
	}

	public function poNumber($poID){
		$a 			= mysqli_query($this->conn, "SELECT * FROM purchase_order_master WHERE purchaseID = $poID ");
		$row 		= mysqli_fetch_assoc($a);
		return $row['purch_custm_po_num'];
	}

	public function poDate($poID){
		$a 			= mysqli_query($this->conn, "SELECT * FROM purchase_order_master WHERE purchaseID = $poID ");
		$row 		= mysqli_fetch_assoc($a);
		return $row['purch_po_date'];
	}

}

?>