<?php
error_reporting(0);
class MonthlyReport{
    private $conn;

	private $customerID;
    private $fromDate;
    private $toDate;
    
    private $companyDetails		= array();
    private $customerDetails	= array();
    private $poIDs 				= array();
    private $partIDs			= array();
    private $doNumbers 			= array();
    private $invoiceList 		= array();
    private $dcList 			= array();
    private $receiptList 		= array();
    private $despatchList 		= array();
    private $reportList 		= array(); 
    private $reportError 		= false; 
	
	public function __construct($customerID, $fromDate, $toDate){
		global $con;
		$this->conn 		= $con;
		$this->customerID 	= $customerID;
		$this->fromDate 	= $fromDate;
		$this->toDate 		= $toDate;
	}

	public function generateReport(){
		$this->companyDetails 	= $this->companyDetails();
		$this->customerDetails 	= $this->customerDetails();
		$this->poIDs 			= $this->purchaseOrderIDs();
		if(count($this->poIDs) == 0){
			echo "No PO found for this customer: ".$this->customerDetails['customerName'] ." -- ID:".$this->customerID;
			exit;
		}

		$this->partIDs 			= $this->partIDs();
		if(count($this->partIDs) == 0){
			echo "No Parts found for this customer: ".$this->customerDetails['customerName'] ." -- ID:".$this->customerID;
			exit;
		}

		$this->receiptList 		= $this->doList();
		$this->despatchList 	= $this->despatchList();
		$this->reportList 		= $this->filterReport();
		
		if($this->reportError){
			echo $this->reportError; exit;
		}

		$this->saveCurrentBalance();

		//echo '<pre>'; print_r($this->reportList); exit;

		$this->exportReport();
	}

	private function companyDetails(){
		$qEx = mysqli_query($this->conn, "SELECT * FROM company_master ORDER BY masterID DESC LIMIT 1");
		$qFetched = $qEx->fetch_object();
		return array('companyName' => $qFetched->comp_name, 'companyAddress' => $qFetched->comp_addrs);
	}

	private function customerDetails(){
		$qEx = mysqli_query($this->conn, "SELECT * FROM customer_master WHERE custmID = $this->customerID LIMIT 1");
		$qFetched = $qEx->fetch_object();
		if(count($qFetched)){
			return array('customerName' => $qFetched->custm_name, 'customerAddress' => $qFetched->custm_addrs);
		}
		return array('customerName' => '', 'customerAddress' => '');
	}

	private function purchaseOrderIDs(){
		$qEx 		= mysqli_query($this->conn, "SELECT * FROM purchase_order_master WHERE customerID = $this->customerID ");
		$poIDs 		= array();
		while($poID = mysqli_fetch_assoc($qEx)){
			$poIDs[] = $poID['purchaseID'];
		}
		return $poIDs;
	}

	private function doList(){
		$doList = array();
		if(count($this->poIDs) == 0){
			return $doList;
		}
		
		$poIDsString = implode(',', $this->poIDs);
		$qEx = mysqli_query($this->conn, "SELECT delivery_order_master.dely_od_dopo, delivery_order_master.dely_od_date, delivery_order_master.qtyOnStart, delivery_order_master.poID, delivery_order_master.dely_od_id, delivery_order_master.partID, purchase_order_master.purch_custm_po_num FROM delivery_order_master LEFT JOIN purchase_order_master ON purchase_order_master.purchaseID = delivery_order_master.poID WHERE poID IN ($poIDsString) AND (STR_TO_DATE(dely_od_date, '%d/%m/%Y') BETWEEN '$this->fromDate' AND '$this->toDate' ) ");

		while($doDetail = mysqli_fetch_assoc($qEx)){
			$thisDO 				= array();
			$thisDO['doNumber'] 	= $doDetail['dely_od_dopo'];
			$thisDO['doDate'] 		= $doDetail['dely_od_date'];
			$thisDO['arrivedQty'] 	= $doDetail['qtyOnStart'];
			$thisDO['poID'] 		= $doDetail['poID'];
			$thisDO['partID'] 		= $doDetail['partID'];
			$thisDO['poNumber'] 	= $doDetail['purch_custm_po_num'];
			$thisDO['doID'] 		= $doDetail['dely_od_id'];
			$doList[] 				= $thisDO;

			$this->doNumbers[] 		= "'". $thisDO['doNumber']. "'";
		}
		return $doList;
	}

	private function despatchList(){
		$this->invoiceList();
		$this->dcList();
		$despatchList 	= array_merge($this->invoiceList, $this->dcList);
		
		$sortBy = array();
		foreach ($despatchList as $key => $row){
		    $sortBy[$key] = $row['sortDate'];
		}

		array_multisort($sortBy, SORT_ASC, $despatchList);

		return ($despatchList);
	}

	private function invoiceList(){
		if(count($this->poIDs) == 0){
			return 0;
		}

		$poIDs_str 	= implode(',', $this->poIDs);
		$qEx 			= mysqli_query($this->conn, "SELECT *, STR_TO_DATE(report_invcdate, '%d/%m/%Y') AS sortDate FROM invoices_report WHERE poID IN ($poIDs_str) AND ( STR_TO_DATE(report_invcdate, '%d/%m/%Y') BETWEEN '$this->fromDate' AND '$this->toDate')");
		
		while($invoiceDetail = mysqli_fetch_assoc($qEx)){
			$invoiceDetail['invoice'] 	= 1;
			$invoiceDetail['dc'] 		= 0;
			$invoiceDetail['dcNo'] 		= explode('/', $invoiceDetail['report_invcno'])[0];
			$invoiceDetail['dcDate'] 	= $invoiceDetail['report_invcdate'];
			$this->invoiceList[] 		= $invoiceDetail;
		}
	}

	private function dcList(){
		if(count($this->poIDs) == 0){
			return 0;
		}

		$poIDs_str 	= implode(',', $this->poIDs);
		$qEx = mysqli_query($this->conn, "SELECT *, date AS sortDate, DATE_FORMAT(date, '%d/%m/%Y') AS dcDates FROM rejection_report WHERE poID IN ($poIDs_str) AND (date BETWEEN '$this->fromDate' AND '$this->toDate')");

		while($dcDetail = mysqli_fetch_assoc($qEx)){
			$dcDetail['dc'] 		= 1;
			$dcDetail['invoice'] 	= 0;
			$dcDetail['dcNo'] 		= explode('/', $dcDetail['rejectionID'])[0];
			$dcDetail['dcDate'] 	= $dcDetail['dcDates'];//$dcDetail['date'];
			$this->dcList[] 		= $dcDetail;
		}
	}

	private function partIDs(){
		$partIDs 	= array();
		if(count($this->poIDs) == 0){
			return $partIDs;
		}

		$qEx 		= mysqli_query($this->conn, "SELECT * FROM item_master WHERE poID IN (". implode(',', $this->poIDs) .")" );	
		while($itemMasterDetail = mysqli_fetch_assoc($qEx)){
			$partIDs[] = $itemMasterDetail['partID'];
		}
		
		$partIDs_Unique = array_unique($partIDs);
		$partIDs = array();
		foreach($partIDs_Unique as $eachPart){
			$partIDs[] = $eachPart;
		}

		return $partIDs;
	}

	private function filterReport(){
		$monthlyReport 			= array();
		
		for($i = 0; $i < count($this->partIDs); $i++){
			$thisReport = array();
			
			$thisReport['partID'] 	= $this->partIDs[$i];
			$qEx = mysqli_query($this->conn, "SELECT * FROM part_master WHERE part_id = ". $this->partIDs[$i]);
			$qFetched = $qEx->fetch_object();

			if(count($qFetched) == 0){
				continue;
			}
			$thisReport['partName'] = $qFetched->part_name;
			$thisReport['partNumber'] = $qFetched->part_no;
			
			$qEx = mysqli_query($this->conn, "SELECT * FROM opening_stock WHERE customerID = $this->customerID AND partID = ". $this->partIDs[$i]);
			$qFetched = $qEx->fetch_object();
			if(!count($qFetched)){
				$this->reportError = "No opening stock for Part Number: ". $thisReport['partNumber'] ." (ID: ". $this->partIDs[$i] ."), Customer:".$this->customerDetails['customerName'] ." (ID: ". $this->customerID .")";
				break;
			}

			$openingStock 				= $qFetched->openingStock;
			$openingStockDate 			= $qFetched->date;
			$jCount 					= count($this->receiptList) > count($this->despatchList)? count($this->receiptList): count($this->despatchList);
			$receivedQty 				= 0;
			$despatchedQty 				= 0;
			$receiptQty 				= 0;
			$closingQty 				= 0;
			$thisReport['receiptList'] 	= array();
			$thisReport['despatchList'] = array();
			
			for($j = 0; $j < $jCount; $j++){
				$partListNumber = 0;
				for($k = 1; $k <= 5; $k++){
					if(!$partListNumber && isset($this->despatchList[$j])){
						if($this->partIDs[$i] == $this->despatchList[$j]['part'.$k.'ID']){
							$partListNumber = $k;
						}
					}
				}
				
				if(isset($this->receiptList[$j]) && $this->receiptList[$j]['partID'] == $this->partIDs[$i]){

					$thisReport['receiptList'][] = array(
						'partID' 		=> $this->receiptList[$j]['partID'],
						'doNumber' 		=> $this->receiptList[$j]['doNumber'],
						'poNumber' 		=> $this->receiptList[$j]['poNumber'],
						'doDate' 		=> $this->receiptList[$j]['doDate'],
						'arrivedQty' 	=> $this->receiptList[$j]['arrivedQty']
					);

					$receivedQty += $this->receiptList[$j]['arrivedQty'];
				}
					
				if(isset($this->despatchList[$j]) && $partListNumber){
					
					$thisReport['despatchList'][] = array(
						'partID' 	=> $this->despatchList[$j]['part'.$partListNumber .'ID'],
						'dcNo' 		=> $this->despatchList[$j]['dcNo'],
						'dcDate' 	=> $this->despatchList[$j]['dcDate'],
						'partQty' 	=> $this->despatchList[$j]['part'.$partListNumber .'_qty']
					);

					$despatchedQty += $this->despatchList[$j]['part'.$partListNumber .'_qty'];
				}

			}
			$receiptQty 					= $openingStock + $receivedQty;
			$closingQty 					= $receiptQty - $despatchedQty;

			$thisReport['openingStock'] 	= $openingStock;
			$thisReport['openingStockDate'] = $openingStockDate;
			$thisReport['receivedQty'] 		= $receivedQty;
			$thisReport['receiptQty'] 		= $receiptQty;
			$thisReport['despatchQty'] 		= $despatchedQty;
			$thisReport['closingBalance'] 	= $closingQty;
			$thisReport['closingDate'] 		= $this->toDate;
			$monthlyReport[] 				= $thisReport;
		}
		
		return $monthlyReport;
	}

	private function exportReport(){
		$objPHPExcel 	= new PHPExcel();

		$objPHPExcel->getProperties()->setCreator("Me")->setLastModifiedBy("Me")
			->setTitle("My Excel Sheet")->setSubject("My Excel Sheet")->setDescription("Excel Sheet")
			->setKeywords("Excel Sheet")->setCategory("Me");


		$centerStyle = array(
	        'alignment' => array(
	            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	        )
	    );


		$reportList = $this->reportList;
		$fileName 	= 'Customer_Report_'.time();
		for($i = 0; $i < count($reportList); $i++){
			$thisPart = $this->reportList[$i];
			$sheetTitle = preg_replace('~[^A-Za-z0-9- ]+~', '', $thisPart['partNumber']);
			$objPHPExcel->createSheet($i);
			$objPHPExcel->setActiveSheetIndex($i);
			$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setName('Arial');
			$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setSize(10);

			$objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(16);

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(13);
			$objPHPExcel->getActiveSheet()->setTitle($sheetTitle);
			
			$columnAlpha = 'A';
			$rowNumber 	 = 1;
			
			//Company Details
			$objPHPExcel->getActiveSheet()->setCellValue('A1', 'From:-');
			$objPHPExcel->getActiveSheet()->setCellValue('A2', $this->companyDetails['companyName']);
			$objPHPExcel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
			$companyAddressSplited = explode("\n", $this->companyDetails['companyAddress']);
			$rowAlpha = 3;
			foreach($companyAddressSplited as $splitedAddr){
				$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowAlpha++, trim($splitedAddr));
			}

			//Customer Details
			$objPHPExcel->getActiveSheet()->setCellValue('G1', 'To:-');
			$objPHPExcel->getActiveSheet()->setCellValue('G2', $this->customerDetails['customerName']);
			$objPHPExcel->getActiveSheet()->getStyle('G2')->getFont()->setBold(true);
			$customerAddressSplited = explode("\n", $this->customerDetails['customerAddress']);
			$rowBeta = 3;
			foreach($customerAddressSplited as $splitedAddr){
				$objPHPExcel->getActiveSheet()->setCellValue('G'.$rowBeta++, trim($splitedAddr));
			}

			$rowNumber = $rowAlpha >= $rowBeta? ($rowAlpha + 1): ($rowBeta + 1);
			
			//Report title
			$reportTitle = 'SUB CONTRACT RAW  MATERIAL RECONSILATION STATEMENT  AS ON  '. date('d/m/Y', strtotime($this->toDate));
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$rowNumber.':M'.$rowNumber);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber.':M'.$rowNumber)->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, $reportTitle);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->getFont()->setBold(true);
			$rowNumber++;

			//Part Number
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$rowNumber.':B'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, 'Part No.');
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$rowNumber++, $thisPart['partNumber']);

			//Part Name
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$rowNumber.':B'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, 'Part Name.');
			$objPHPExcel->getActiveSheet()->mergeCells('C'.$rowNumber.':H'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$rowNumber++, $thisPart['partName']);

			//Receipt Title
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$rowNumber.':G'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, 'RECEIPTS');
			$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->getFont()->setBold(true);

			//Despatch Title
			$objPHPExcel->getActiveSheet()->mergeCells('H'.$rowNumber.':M'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('H'.$rowNumber, 'DESPATCH');
			$objPHPExcel->getActiveSheet()->getStyle('H'.$rowNumber)->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->getStyle('H'.$rowNumber)->getFont()->setBold(true);
			$rowNumber++;
			//$rowNumber++;

			//List Head
			$listHeads = array(
					'S.No', 'SDN.No.', 'PO NO', 'Date', 'No of Bars', 'Qty In Nos', 
					'Weight /Kgs', 'DC.No', 'Date', 'GRN NO', 'Qty', 'Weight/Rack', 'wt'
			);

			$columnAlpha = 'A';
			foreach($listHeads as $lh){
				$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.$rowNumber, $lh);
				$objPHPExcel->getActiveSheet()->getStyle($columnAlpha.$rowNumber)->applyFromArray($centerStyle);
				$columnAlpha++;
			}
			$rowNumber++;

			$rowAlpha = $rowNumber;

			//Opening Info
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$rowNumber.':C'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, date('d/m/Y', strtotime($thisPart['openingStockDate'])));
			$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->applyFromArray($centerStyle);

			$objPHPExcel->getActiveSheet()->setCellValue('F'.$rowNumber, $thisPart['openingStock']);

			$rowNumber++;
			

			for($j = 0; $j < count($thisPart['receiptList']); $j++){
				$thisLine = $thisPart['receiptList'][$j];
				$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, $j + 1);
				$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->applyFromArray($centerStyle);
				$objPHPExcel->getActiveSheet()->setCellValue('B'.$rowNumber, $thisLine['doNumber']);
				$objPHPExcel->getActiveSheet()->setCellValue('C'.$rowNumber, $thisLine['poNumber']);
				$objPHPExcel->getActiveSheet()->setCellValue('D'.$rowNumber, $thisLine['doDate']);
				$objPHPExcel->getActiveSheet()->setCellValue('F'.$rowNumber, $thisLine['arrivedQty']);
				$rowNumber++;
			}

			$rowBeta 	= $rowNumber;
			$rowNumber 	= $rowAlpha;
			for($j = 0; $j < count($thisPart['despatchList']); $j++){
				$thisLine = $thisPart['despatchList'][$j];
				$objPHPExcel->getActiveSheet()->setCellValue('H'.$rowNumber, $thisLine['dcNo']);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$rowNumber)->getFont()->setBold(true);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$rowNumber)->applyFromArray($centerStyle);
				$objPHPExcel->getActiveSheet()->setCellValue('I'.$rowNumber, $thisLine['dcDate']);
				$objPHPExcel->getActiveSheet()->setCellValue('K'.$rowNumber, $thisLine['partQty']);
				$rowNumber++;
			}

			$rowNumber = $rowNumber >= $rowBeta? $rowNumber: $rowBeta;

			//Opening + Receipt
			$objPHPExcel->getActiveSheet()->mergeCells('B'.$rowNumber.':C'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$rowNumber, 'Opening + Receipts');
			$objPHPExcel->getActiveSheet()->setCellValue('F'.$rowNumber, $thisPart['receiptQty']);
			$objPHPExcel->getActiveSheet()->setCellValue('K'.$rowNumber, $thisPart['despatchQty']);
			$rowNumber++;

			//Closing Balance
			$objPHPExcel->getActiveSheet()->mergeCells('H'.$rowNumber.':J'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('H'.$rowNumber, 'CLOSING BALANCE');
			$objPHPExcel->getActiveSheet()->getStyle('H'.$rowNumber)->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->setCellValue('K'.$rowNumber, $thisPart['closingBalance']);
		}

		//PART LIST ON LAST SHEET
		$objPHPExcel->createSheet($i);
		$objPHPExcel->setActiveSheetIndex($i);
		$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setName('Arial');
		$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setSize(10);

		$objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(16);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(13);
		$objPHPExcel->getActiveSheet()->setTitle('Parts Summary');

		//Company Details
		$objPHPExcel->getActiveSheet()->setCellValue('A1', 'From:-');
		$objPHPExcel->getActiveSheet()->setCellValue('A2', $this->companyDetails['companyName']);
		$objPHPExcel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);
		$companyAddressSplited = explode("\n", $this->companyDetails['companyAddress']);
		$rowAlpha = 3;
		foreach($companyAddressSplited as $splitedAddr){
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowAlpha++, trim($splitedAddr));
		}

		//Customer Details
		$objPHPExcel->getActiveSheet()->setCellValue('G1', 'To:-');
		$objPHPExcel->getActiveSheet()->setCellValue('G2', $this->customerDetails['customerName']);
		$objPHPExcel->getActiveSheet()->getStyle('G2')->getFont()->setBold(true);
		$customerAddressSplited = explode("\n", $this->customerDetails['customerAddress']);
		$rowBeta = 3;
		foreach($customerAddressSplited as $splitedAddr){
			$objPHPExcel->getActiveSheet()->setCellValue('G'.$rowBeta++, trim($splitedAddr));
		}

		$rowNumber = $rowAlpha >= $rowBeta? ($rowAlpha + 1): ($rowBeta + 1);

		//Report title
		$reportTitle = 'PARTS SUMMARY';
		$objPHPExcel->getActiveSheet()->mergeCells('A'.$rowNumber.':E'.$rowNumber);
		$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber.':E'.$rowNumber)->applyFromArray($centerStyle);
		$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, $reportTitle);
		$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->getFont()->setBold(true);
		$rowNumber++;

		//List Head
		$listHeads = array(
				'S.No', 'PART NO', 'PART NAME', 'CLOSING BALANCE', 'DATE');

		$columnAlpha = 'A';
		foreach($listHeads as $lh){
			$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.$rowNumber, $lh);
			$objPHPExcel->getActiveSheet()->getStyle($columnAlpha.$rowNumber)->applyFromArray($centerStyle);
			$columnAlpha++;
		}
		$rowNumber++;

		//PART LIST
		for($i = 0; $i < count($reportList); $i++){
			$thisPart = $this->reportList[$i];
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, $i + 1);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$rowNumber, $thisPart['partNumber']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$rowNumber, $thisPart['partName']);
			$objPHPExcel->getActiveSheet()->setCellValue('D'.$rowNumber, $thisPart['closingBalance']);
			$objPHPExcel->getActiveSheet()->setCellValue('E'.$rowNumber, date('d/m/Y', strtotime($this->toDate)));
			$rowNumber++;
		}


		//OTHER PROCESS
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		
		$outputType = false;

		if($outputType){
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="' . $fileName . '.xlsx"');
			header('Cache-Control: max-age=0');
			$objWriter->save('php://output');
		} else {
			$objWriter->save('files/customer-report/' . $fileName . '.xlsx');
			$output =  ("<a href='files/customer-report/". $fileName .".xlsx'>Open Your Excel Document</a>");
			echo $output;
		}
	}

	private function saveCurrentBalance(){
		for($i = 0; $i < count($this->reportList); $i++){
			mysqli_query($this->conn, 
				"UPDATE opening_stock SET 
					currentDate = '$this->toDate', 
					currentBalance = ".$this->reportList[$i]['closingBalance']." 
					WHERE 
						customerID = $this->customerID AND 
						partID = ".$this->reportList[$i]['partID']
			);
		}
	}
}

?>