<?php

class DCReportIO {

	private $category;
	private $supplierID;
	private $fromDate;
	private $toDate;
	
	private $poIDs 			= [];
	private $dcIDs 			= [];
	private $partIDs 		= [];

	private $dcList 		= [];
	private $listByParts 	= [];
    private $reportList 	= [];

    private $exportMode  	= false;
    

	public function __construct($category, $type, $fromDate, $toDate) {

		$this->createFolderIfDoesntExist();

		$this->category 	= $category;
		$this->type 		= $type;
		$this->supplierID 	= 0;
		$this->fromDate 	= $fromDate;
		$this->toDate 		= $toDate;

		if ($this->type == 'ALL') {
			$this->types = "'JOBWORK', 'RETURN', 'NORETURN'";
		} else {
			$this->types = "'".$this->type."'";
		}

		$companyID 			= QFunc::fetchField('company_master', 'id');
		$this->company 		= Company::find($companyID);

		$this->generateReport();
	}

	private function createFolderIfDoesntExist () {
		
		if (!file_exists('file/report/dc-supplier/')) {
			mkdir("file/report/dc-supplier/", 0777, true);
		}
	}

	public function generateReport(){
        $this->fetchPO();
		$this->fetchList();

		$this->listByParts();
		$this->splitInwardsOutwards();
        
		$this->prepareSheetData();
		$this->exportReport();
	}

	public function fetchPO(){
		$poTable 	= $this->category == 'SERVICE'? 'purchase_order_service': 'purchase_order_goods';
		$qPOIDs 	= QFunc::fetchAssoc($poTable, true);//, ['supplierID' => $this->supplierID]);
		$poIDs 		= [];
		foreach($qPOIDs as $poID){
			$poIDs[] = $poID['id'];
		}

		$this->poIDs = $poIDs;
	}

	private function fetchList() {
		
		if(count($this->poIDs) == 0) { return 0; }

		$poIDstr 	= implode(',', $this->poIDs);
		
		$dcList 		= QFunc::fetchResult(
				"SELECT * FROM dc_report 
                WHERE category = '{$this->category}' AND type IN ($this->types) AND poID IN ($poIDstr) 
                    AND STR_TO_DATE(dcDate, '%d/%m/%Y') >= STR_TO_DATE('{$this->fromDate}', '%d/%m/%Y') AND STR_TO_DATE(dcDate, '%d/%m/%Y') <= STR_TO_DATE('{$this->toDate}', '%d/%m/%Y') 
                    AND status IN('PENDING', 'COMPLETE') ORDER BY STR_TO_DATE(dcDate, '%d/%m/%Y') "
        );

		foreach ($dcList as $eachDC) {
			$this->dcList[] = DC::findByID($eachDC['id']);
		}

		$partIDs = [];
		foreach($this->dcList as $eachDC){
			$this->dcIDs[] = $eachDC->id;

			for($i = 1; $i <= $eachDC->totalParts; $i++){
				$i_PartID = 'part'.$i.'ID';
				$partIDs[] = $eachDC->$i_PartID;
			}
		}

		$this->partIDs = array_values(array_unique($partIDs));
	}

	private function listByParts(){
		$listAlpha = [];

		for($i = 0; $i < count($this->dcList); $i++){
			$dc = $this->dcList[$i];

			for($j = 1; $j <= $dc->totalParts; $j++){
				$partQty 	= 'part'.$j.'Qty';
				$partID 	= 'part'.$j.'ID';

				$ji_List 				    = [];
				$ji_List['dcID'] 		    = $dc->id;
				$ji_List['category'] 	    = $dc->category;
				$ji_List['type'] 		    = $dc->type;
				$ji_List['dcNumber'] 	    = $dc->dcNumber;
				$ji_List['dcDate'] 		    = $dc->dcDate;
				$ji_List['sentQty'] 	    = $dc->$partQty;
				$ji_List['partID'] 		    = $dc->$partID;
				$ji_List['partName'] 	    = $dc->part1Name;
				$ji_List['partPrice'] 	    = $dc->part1Price;
				$ji_List['partTaxablePrice']= $dc->part1TaxablePrice;
				$ji_List['supplierName']    = $dc->supplier->name;
				$ji_List['supplierGST']     = $dc->supplier->gst;
				$ji_List['partIGST']     	= $dc->part->igst;
				$ji_List['partCGST']     	= $dc->part->cgst;
				$ji_List['partSGST']     	= $dc->part->sgst;
				$invoices 				    = VendorInvoice::findByDC($this->dcList[$i]->id);
				
				$jj_List 	= [];
				$k_thisQty 	= 0;
				for($k = 0; $k < count($invoices); $k++){
					$invoice 					= $invoices[$k];
					
					if($invoice->$partQty == NULL || $invoice->$partQty == 0){ 
						continue; 
					}
					
					$k_thisQty 					+= $invoice->$partQty;

					$ki_List['invoiceID'] 		= $invoice->id;
					$ki_List['dcID'] 			= $invoice->dcID;
					$ki_List['invoiceNumber'] 	= $invoice->invoiceNumber;
					$ki_List['invoiceType'] 	= $invoice->invoiceType;
					$ki_List['invoiceDate'] 	= $invoice->invoiceDate;
					$ki_List['receivedQty'] 	= $invoice->invoiceType == 'DESPATCH'? 	$invoice->$partQty: 0;
					$ki_List['rejectedQty'] 	= $invoice->invoiceType == 'REJECT'? 	$invoice->$partQty: 0;
					$ki_List['balanceQty'] 		= $dc->$partQty - $k_thisQty;
					$ki_List['status'] 			= ($dc->$partQty - $k_thisQty) == 0? 'CLOSED': 'OPEN';
					$jj_List[] = $ki_List;
				}

				// $this->listByParts[$dc->$partID][] = ['DC' => $ji_List, 'INVOICE' => $jj_List];
				$this->listByParts[] = ['DC' => $ji_List, 'INVOICE' => $jj_List];
			}
		}
        
	}

    private function splitInwardsOutwards () {

        $inwards = [];
        $outwards = [];

        foreach ($this->listByParts as $eachDC) {
            
            $thisOutward                 = new StdClass;
            $thisOutward->supplierName   = $eachDC['DC']['supplierName'];
            $thisOutward->supplierGST    = $eachDC['DC']['supplierGST'];
            $thisOutward->type           = $eachDC['DC']['type'];
            $thisOutward->category       = $eachDC['DC']['category'];
            $thisOutward->dcNumber       = $eachDC['DC']['dcNumber'];
            $thisOutward->dcDate         = $eachDC['DC']['dcDate'];
            $thisOutward->sentQty        = $eachDC['DC']['sentQty'];
            $thisOutward->partName       = $eachDC['DC']['partName'];
            $thisOutward->partPrice      = $eachDC['DC']['partPrice'];
            $thisOutward->dcDate         = $eachDC['DC']['dcDate'];
            $thisOutward->taxablePrice   = $thisOutward->partPrice * $thisOutward->sentQty;

            $thisOutward->igstPrice    	= xPercentageOfY($eachDC['DC']['partIGST'], $thisOutward->taxablePrice);
            $thisOutward->cgstPrice    	= xPercentageOfY($eachDC['DC']['partCGST'], $thisOutward->taxablePrice);
            $thisOutward->sgstPrice    	= xPercentageOfY($eachDC['DC']['partSGST'], $thisOutward->taxablePrice);


            foreach ($eachDC['INVOICE'] as $eachInvoice) {

                $thisInward                 = new StdClass;
                $thisInward->supplierName   = $eachDC['DC']['supplierName'];
                $thisInward->supplierGST    = $eachDC['DC']['supplierGST'];
                $thisInward->category       = $eachDC['DC']['category'];
                $thisInward->type           = $eachDC['DC']['type'];
                $thisInward->dcNumber       = $eachDC['DC']['dcNumber'];
                $thisInward->dcDate         = $eachDC['DC']['dcDate'];
                $thisInward->sentQty        = $eachDC['DC']['sentQty'];
                $thisInward->partName       = $eachDC['DC']['partName'];
                $thisInward->partPrice      = $eachDC['DC']['partPrice'];

                $thisInward->invoiceNumber  = $eachInvoice['invoiceNumber'];
                $thisInward->invoiceType  	= $eachInvoice['invoiceType'];
                $thisInward->invoiceDate  	= $eachInvoice['invoiceDate'];
                $thisInward->receivedQty  	= $eachInvoice['receivedQty'];
                $thisInward->rejectedQty  	= $eachInvoice['rejectedQty'];
                $thisInward->balanceQty  	= $eachInvoice['balanceQty'];
				
				$thisInward->taxablePrice   = $thisInward->partPrice * $thisInward->receivedQty;

                $inwards[] = $thisInward;
            }

            $outwards[] = $thisOutward;
        }

        $this->outwards = $outwards;
        $this->inwards = $inwards;
    }

	public function prepareSheetData () {
		
		$outwardsSheet = [];
        foreach ($this->outwards as $eachOutward) {


            $outwardRow = [];
            $outwardRow['SUPPLIER']                 = $eachOutward->supplierName;
            $outwardRow['SUPPLIER GST']             = $eachOutward->supplierGST;
            $outwardRow['STATE']                    = $eachOutward->type;
            $outwardRow['CHALLAN NUMBER']           = $eachOutward->dcNumber;
            $outwardRow['DC DATE']            		= $eachOutward->dcDate;
            $outwardRow['DESC OF GOODS']           	= $eachOutward->partName;
            $outwardRow['UCQ']            			='NOS';
            $outwardRow['QUANTITY']            		= $eachOutward->sentQty;
            $outwardRow['PER RATE']            		= $eachOutward->partPrice;
            $outwardRow['TAXABLE RATE']            	= $eachOutward->taxablePrice;
            $outwardRow['TYPES OF GOODS']           = '';
            $outwardRow['IGST RATE']            	= $eachOutward->igstPrice;
            $outwardRow['CGST RATE']            	= $eachOutward->cgstPrice;
            $outwardRow['SGST RATE']            	= $eachOutward->sgstPrice;
            $outwardRow['CESS']            			= '';
            $outwardRow['ERRORS']            		= '';

			$outwardsSheet[] = $outwardRow;
       }

		$inwardsSheet = [];
        foreach ($this->inwards as $eachInward) {
            
            $inwardRow = [];
            $inwardRow['SUPPLIER']                 	= $eachInward->supplierName;
            $inwardRow['SUPPLIER GST']             	= $eachInward->supplierGST;
            $inwardRow['STATE']                    	= $eachInward->type;
            $inwardRow['NATURE OF TRANSACTION']    	= 'MACHINING';
            $inwardRow['DC DATE']            		= $eachInward->invoiceDate;
            $inwardRow['DC NUMBER']            		= $eachInward->invoiceNumber;
            $inwardRow['CHALLAN NUMBER']           	= $eachInward->dcNumber;
            $inwardRow['CHALLAN DATE']           	= $eachInward->dcDate;
            $inwardRow['DESC OF GOODS']           	= $eachInward->partName;
            $inwardRow['UCQ']            			='NOS';
            $inwardRow['QUANTITY']            		= $eachInward->sentQty;
            $inwardRow['PER RATE']            		= $eachInward->partPrice;
            $inwardRow['TAXABLE RATE']            	= $eachInward->taxablePrice;
            $inwardRow['ERRORS']            		= '';

			$inwardsSheet[] = $inwardRow;
        }

		$this->outwardsSheet 	= $outwardsSheet;
		$this->inwardsSheet 	= $inwardsSheet;
	}

	

	public function exportReport(){
		$reportList 	= $this->reportList;

		$objPHPExcel 	= new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Me")->setLastModifiedBy("Me")->setTitle("My Excel Sheet")->setSubject("My Excel Sheet")->setDescription("Excel Sheet")->setKeywords("Excel Sheet")->setCategory("Me");

		$centerStyle = array(
	        'alignment' => array(
	            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
	        )
	    );

		//Outwards
		
		$this->insertOutwardsSheet($objPHPExcel);
		$this->insertInwardsSheet($objPHPExcel);
		$this->downloadReport($objPHPExcel);

	}

	private function insertOutwardsSheet ($objPHPExcel) {
		
		$objPHPExcel->createSheet(0);
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->setTitle('Outwards');

		$this->insertOutwardsTitle($objPHPExcel);
		$this->insertOutwardsData($objPHPExcel);
	}

	private function insertInwardsSheet ($objPHPExcel) {
		
		$objPHPExcel->createSheet(1);
		$objPHPExcel->setActiveSheetIndex(1);
		$objPHPExcel->getActiveSheet()->setTitle('Inwards');

		$this->insertInwardsTitle($objPHPExcel);
		$this->insertInwardsData($objPHPExcel);
	}

	private function insertOutwardsTitle ($objPHPExcel) {
		
		$columnTitles 	= [
			'SUPPLIER', 'GSTIN of Job Worker(JW) *', 'State (in case of unregistered JW) *', 'Challan Number *', 
			'Challan Date (dd-mm-yyyy) *', 'Description of Goods *', 'Unique Quantity Code (UQC) *', 
			'Quantity  *', 'Per Rate', 'Taxable Value *', 'Types of Goods*', 
			'Integrated Tax Rate in (%) *', 'Central Tax Rate in (%)*', 'State/UT Tax Rate in (%)*', 'Cess', 'Errors',
		];

		$columnAlpha = 'A';
		for($j = 0; $j < count($columnTitles); $j++, $columnAlpha++){
			$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.'1', $columnTitles[$j]);
			// $objPHPExcel->getActiveSheet()->getStyle($columnAlpha.'5')->applyFromArray($centerStyle);
			// $objPHPExcel->getActiveSheet()->getStyle($columnAlpha.'5')->applyFromArray($bgGray);
		}
	}

	private function insertInwardsTitle ($objPHPExcel) {
		
		$columnTitles 	= [
			'SUPPLIER', 'GSTIN of Job Worker(JW) *', 'State (in case of unregistered JW) *', 'Nature of Transaction *', 'Party DC Date', 'Party DC No', 
			'Original Challan Number *', 'DATE', 'Description of Goods  *', 'Unique Quantity Code (UQC) *', 'Quantity  *', 'Per Rate', 'Taxable Value *', 'Errors'
		];

		$columnAlpha = 'A';
		for($j = 0; $j < count($columnTitles); $j++, $columnAlpha++){
			$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.'1', $columnTitles[$j]);
		}
	}

	private function insertOutwardsData ($objPHPExcel) {
		
		$rowNumber = 2;
		foreach ($this->outwardsSheet as $thisRow) {

			$columnName = 'A';
			foreach ($thisRow as $thisColumn) {
				$objPHPExcel->getActiveSheet()->setCellValue($columnName++.$rowNumber, $thisColumn);
			}
			$rowNumber++;

		}
	}

	private function insertInwardsData ($objPHPExcel) {
		
		$rowNumber = 2;
		foreach ($this->inwardsSheet as $thisRow) {

			$columnName = 'A';
			foreach ($thisRow as $thisColumn) {
				$objPHPExcel->getActiveSheet()->setCellValue($columnName++.$rowNumber, $thisColumn);
			}
			$rowNumber++;

		}
	}

	private function downloadReport ($objPHPExcel) {
		
		$fileName 		= 'DC Inwards Outwards Report_'.time();
		
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		
		if($this->exportMode){
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="' . $fileName . '.xlsx"');
			header('Cache-Control: max-age=0');
			$objWriter->save('php://output');
		} else {
			$objWriter->save('file/report/dc-supplier/' . $fileName . '.xlsx');
			echo '<a href="file/report/dc-supplier/'. $fileName .'.xlsx">Open Your Excel Document</a>'; exit;
		}
	}

}

?>