<?php
	const MYSQL_HOST 		= 'localhost:3306';
	const MYSQL_USER 		= 'root';
	const MYSQL_PASS 		= '';
	const MYSQL_DB 			= 'abrami_vendor';

	const MYSQL_LOC_HOST 	= 'localhost';
	const MYSQL_LOC_USER 	= 'root';
	const MYSQL_LOC_PASS 	= '';
	const MYSQL_LOC_DB 		= 'abrami_vendor';

	const MYSQL_ISLIVE 		= true;

	if(MYSQL_ISLIVE){
		$conn 	= new mysqli(MYSQL_HOST, MYSQL_USER, MYSQL_PASS, MYSQL_DB);
    	$con 	= mysqli_connect(MYSQL_HOST, MYSQL_USER, MYSQL_PASS, MYSQL_DB);
    } else {
    	$conn 	= new mysqli(MYSQL_LOC_HOST, MYSQL_LOC_USER, MYSQL_LOC_PASS, MYSQL_LOC_DB);
    	$con 	= mysqli_connect(MYSQL_LOC_HOST, MYSQL_LOC_USER, MYSQL_LOC_PASS, MYSQL_LOC_DB);
    }
	
	if ($conn->connect_error) {
        die('Connect Error (' . $conn->connect_errno . ') '. $conn->connect_error);
    }


class QFunc{

	public static function executeQuery($query){
		global $conn;
		return mysqli_query($conn, $query);
	}

	public static function buildQuery($tableName, $fieldName, $whereClause = null){
		if(is_array($fieldName)){
			$fieldName = implode(', ', $fieldName);
		} else if($fieldName === true){
			$fieldName = '*';
		}

		$whereClause = is_array($whereClause)? QFunc::buildWhereClause($whereClause): $whereClause;
		$whereClause = !empty($whereClause)? " WHERE $whereClause ": "";
		return "SELECT $fieldName FROM $tableName $whereClause ";
	}

	public static function fetchField($tableName, $fieldName, $whereClause = null){
		$whereClause = is_array($whereClause)? QFunc::buildWhereClause($whereClause): $whereClause;
		$whereClause = !empty($whereClause)? " WHERE $whereClause ": "";

		$textQuery 		= "SELECT $fieldName FROM $tableName $whereClause ";
		$fetchedData 	= QFunc::executeQuery($textQuery);

		if($fetchedData->num_rows){
			return $fetchedData->fetch_object()->$fieldName;
		}
	}

	public static function fetchAssoc($tableName, $fieldName, $whereClause = null){
		if(is_array($fieldName)){
			$fieldName = implode(', ', $fieldName);
		} else if($fieldName === true){
			$fieldName = '*';
		}

		$whereClause = is_array($whereClause)? QFunc::buildWhereClause($whereClause): $whereClause;
		$whereClause = !empty($whereClause)? "WHERE $whereClause": "";

		$textQuery 		= "SELECT $fieldName FROM $tableName $whereClause ";
		$result 		= QFunc::executeQuery($textQuery);
		$resultArray 	= [];

		if($result){
			while($resultTemp 	= $result->fetch_array(MYSQLI_ASSOC)){
				$resultArray[] 	= $resultTemp;
			}
		}
		
		return $resultArray;
	}

	public static function fetchRow($tableName, $fieldName, $whereClause = null){ 
		if(is_array($fieldName)){
			$fieldName = implode(', ', $fieldName);
		} else if($fieldName === true){
			$fieldName = '*';
		}

		$whereClause = is_array($whereClause)? QFunc::buildWhereClause($whereClause): $whereClause;
		$whereClause = !empty($whereClause)? "WHERE $whereClause": "";

		$textQuery 		= "SELECT $fieldName FROM $tableName $whereClause ";
		$result 		= QFunc::executeQuery($textQuery);
		$resultArray 	= [];

		if($result){
			$resultArray 	= $result->fetch_array(MYSQLI_ASSOC);
		}
		
		return $resultArray;
	}

	private static function buildWhereClause($whereClause){
		$whereClauseArray 	= [];
		$arrayKeys			= array_keys($whereClause);
		
		for($i = 0; $i < count($arrayKeys); $i++){
			$fieldName  		= $arrayKeys[$i];
			$fieldValue 		= is_numeric($whereClause[$fieldName])? $whereClause[$fieldName]: "'". $whereClause[$fieldName] ."'";

			$whereClauseArray[] = $fieldName .' = '. $fieldValue;
		}

		return implode(' AND ', $whereClauseArray);
	}

	public static function queryRows($tableName, $whereClause = null){
		$whereClause = is_array($whereClause)? QFunc::buildWhereClause($whereClause): $whereClause;
		$whereClause = !empty($whereClause)? " WHERE $whereClause ": "";

		$executedQuery = QFunc::executeQuery("SELECT id FROM $tableName $whereClause ");
		if($executedQuery){
			return $executedQuery->num_rows;
		} else {
			return 0;
		}
	}

	public static function insertRow($tableName, $fields){
		$arrayKeys 			= array_keys($fields);
		$fieldNameArray 	= [];
		$fieldValueArray 	= [];
		
		for($i = 0; $i < count($arrayKeys); $i++){
			$fieldNameArray[]	= $arrayKeys[$i];
			$fieldValue			= $fields[$arrayKeys[$i]];
			
			if($fieldValue == NULL){
				$fieldValueArray[] = 'NULL';
			} else if(is_numeric($fieldValue)){
				$fieldValueArray[] = $fieldValue;
			} else {
				$fieldValueArray[] = "'". $fieldValue ."'";
			}
		}

		$textQuery = "INSERT INTO $tableName (". implode(', ', $fieldNameArray) .") VALUES(". implode(', ', $fieldValueArray) .")";

		return QFunc::executeQuery($textQuery);
	}

	public static function deleteRow($tableName, $whereClause = null){
		$whereClause 	= is_array($whereClause)? QFunc::buildWhereClause($whereClause): $whereClause;
		$whereClause 	= !empty($whereClause)? " WHERE $whereClause ": "";

		$textQuery 		= "DELETE FROM $tableName $whereClause ";
		
		return QFunc::executeQuery($textQuery);
	}

	public static function updateField($tableName, $fields, $whereClause = null){
		$arrayKeys 			= array_keys($fields);
		$fieldNameArray 	= [];
		$fieldValueArray 	= [];
		$updateFields		= [];

		for($i = 0; $i < count($arrayKeys); $i++){
			$fieldNameArray[$i]		= $arrayKeys[$i];
			$fieldValue				= $fields[$arrayKeys[$i]];
			
			if($fieldValue == NULL){
				$fieldValueArray[$i] = 'NULL';
			} else if(is_numeric($fieldValue)){
				$fieldValueArray[$i] = $fieldValue;
			} else {
				$fieldValueArray[$i] = "'". $fieldValue ."'";
			}

			$updateFields[$i]		= $fieldNameArray[$i] ." = ". $fieldValueArray[$i];
		}

		$whereClause 	= is_array($whereClause)? QFunc::buildWhereClause($whereClause): $whereClause;
		$whereClause 	= !empty($whereClause)? " WHERE $whereClause ": "";

		$updateFields 	= implode(', ', $updateFields);
		$textQuery 		= "UPDATE $tableName SET $updateFields $whereClause ";
		
		return QFunc::executeQuery($textQuery);
	}

	public static function fetchResult($textQuery){
		
		$result 		= QFunc::executeQuery($textQuery);
		$resultArray 	= [];

		if($result){
			while($resultTemp 	= $result->fetch_array(MYSQLI_ASSOC)){
				$resultArray[] 	= $resultTemp;
			}
		}
		
		return $resultArray;
	}

}

?>