<?php

class Company{

	public static function find($id){
		$rData 	= QFunc::fetchRow('company_master', true, ['id' => $id]);
		$newObj = new Company;
		if($rData){
			$newObj->id 			= $rData['id'];
			$newObj->name 			= $rData['name'];
			$newObj->address 		= nl2br($rData['address']);
			$newObj->gst 			= $rData['gst'];
			$newObj->pan 			= $rData['pan'];
			$newObj->sac 			= $rData['sac'];
			$newObj->pinCode 		= $rData['pinCode'];
			$newObj->stateCode 		= $rData['stateCode'];
			$newObj->date 			= $rData['date'];
		}
		return $newObj;
	}
}


class Supplier{

	public static function find($id){
		$rData 	= QFunc::fetchRow('supplier_master', true, ['id' => $id]);
		$newObj = new Supplier;
		if($rData){
			$newObj->id 		= $rData['id'];
			$newObj->name 		= $rData['name'];
			$newObj->address 	= nl2br($rData['address']);
			$newObj->gst 		= $rData['gst'];
			$newObj->pan 		= $rData['pan'];
			$newObj->email 		= $rData['email'];
			$newObj->person 	= $rData['person'];
			$newObj->mobile 	= $rData['mobile'];
			$newObj->stateCode 	= $rData['stateCode'];
			$newObj->pinCode 	= $rData['pinCode'];
			$newObj->distance 	= $rData['distance'];
			$newObj->status 	= $rData['status'];
			$newObj->date 		= $rData['date'];
		}
		return $newObj;
	}

	public static function poIDs($supplierID){
		$servicePOs = QFunc::fetchAssoc('purchase_order_service', 'id', ['supplierID' => $supplierID]);
		$goodsPOs 	= QFunc::fetchAssoc('purchase_order_goods', 'id', ['supplierID' => $supplierID]);
		$poIDs 		= ['SERVICE' => [], 'GOODS' => []];
		
		foreach($servicePOs as $servicePO){
			$poIDs['SERVICE'][] = $servicePO['id'];
		}

		foreach($goodsPOs as $goodsPO){
			$poIDs['GOODS'][] = $goodsPO['id'];
		}

		return $poIDs;
	}
}

class Part{

	public static function find($id){
		$rData 	= QFunc::fetchRow('part_master', true, ['id' => $id]);
		$newObj = new Part;
		if($rData){
			$newObj->id 			= $rData['id'];
			$newObj->name 			= $rData['name'];
			$newObj->number 		= $rData['number'];
			$newObj->uom 			= $rData['uom'];
			$newObj->hsn 			= $rData['hsn'];
			$newObj->cgst 			= (float) $rData['cgst'];
			$newObj->sgst 			= (float) $rData['sgst'];
			$newObj->igst 			= (float) $rData['igst'];
			$newObj->ugst 			= (float) $rData['ugst'];
			$newObj->tcs 			= (float) $rData['tcs'];
		}
		return $newObj;
	}
}


class Service{

	public static function findPO($id){
		$rData 	= QFunc::fetchRow('purchase_order_service', true, ['id' => $id]);
		$newObj = new Service;
		if($rData){
			$newObj->id 			= $rData['id'];
			$newObj->poNumber 		= $rData['poNumber'];
			$newObj->supplierID 	= $rData['supplierID'];
			$newObj->poDate 		= $rData['poDate'];
			$newObj->date 			= $rData['date'];
		}
		return $newObj;
	}
}

class Goods{

	public static function findPO($id){
		$rData 	= QFunc::fetchRow('purchase_order_goods', true, ['id' => $id]);
		$newObj = new Goods;
		if($rData){
			$newObj->id 			= $rData['id'];
			$newObj->poNumber 		= $rData['poNumber'];
			$newObj->supplierID 	= $rData['supplierID'];
			$newObj->poDate 		= $rData['poDate'];
			$newObj->date 			= $rData['date'];
		}
		return $newObj;
	}
}


class DCPart{

	public static function find($category, $id, $qty){
		$newObj 				= new DCPart;
		
		$newObj->itemOrderID 	= $id;
		$newObj->issueQty 		= $qty;
		
		//Item Order
		$tableItemOrder = $category == 'SERVICE'? 'item_order_service': 'item_order_goods';
		$rData 	= QFunc::fetchRow($tableItemOrder, true, ['id' => $id]);
		if($rData){
			$newObj->poID 			= $rData['poID'];
			$newObj->partID 		= $rData['partID'];
			$newObj->currentQty 	= $rData['qty'];
			$newObj->qtyOnStart 	= $rData['qtyOnStart'];
			$newObj->price 			= $rData['price'];
			$newObj->deliveryDate 	= $rData['deliveryDate'];
		}

		//Part
		$rData 	= QFunc::fetchRow('part_master', true, ['id' => $newObj->partID]);
		if($rData){
			$newObj->id 	= $rData['id'];
			$newObj->number = $rData['number'];
			$newObj->name 	= $rData['name'];
			$newObj->uom 	= $rData['uom'];
			$newObj->hsn 	= $rData['hsn'];
			$newObj->cgst 	= $rData['cgst'];
			$newObj->sgst 	= $rData['sgst'];
			$newObj->igst 	= $rData['igst'];
			$newObj->ugst 	= $rData['ugst'];
			$newObj->tcs 	= $rData['tcs'];

			$newObj->value 		= $newObj->issueQty * $newObj->price;
			$newObj->cgstPrice 	= round(($newObj->value * $newObj->cgst) 	/ 100, 2);
			$newObj->sgstPrice 	= round(($newObj->value * $newObj->sgst) 	/ 100, 2);
			$newObj->igstPrice 	= round(($newObj->value * $newObj->igst) 	/ 100, 2);
			$newObj->ugstPrice 	= round(($newObj->value * $newObj->ugst) 	/ 100, 2);
			$newObj->tcsPrice 	= round(($newObj->value * $newObj->tcs) 	/ 100, 2);
		}
		return $newObj;
	}
}

class Serial{

	public static function add($name, $prefix, $serial, $year){
		QFunc::insertRow('serials', [
			'name' 		=> $name,
			'prefix' 	=> $prefix,
			'serial' 	=> $serial,
			'year' 		=> $year
		]);
		return true;
	}

	public static function update($name, $prefix, $serial, $year){
		QFunc::updateField('serials', 
			[
				'prefix' 	=> $prefix,
				'serial' 	=> $serial,
				'year' 		=> $year
			], 
			['name' 		=> $name]
		);
		return true;
	}

	public static function isExist($name){
		return QFunc::fetchField('serials', $field, ['name' => $name]);
	}

	public static function get($name, $field){
		return QFunc::fetchField('serials', $field, ['name' => $name]);
	}

	public static function currentSerial($name){
		$prefix 	= QFunc::fetchField('serials', 'prefix', 	['name' => $name]);
		$serial 	= QFunc::fetchField('serials', 'serial', 	['name' => $name]);
		$year 		= QFunc::fetchField('serials', 'year', 		['name' => $name]);
		$seperator 	= '/';

		return $prefix . $serial . $seperator . $year;
	}

	public static function increment($name){
		$serial = QFunc::fetchField('serials', 'serial', ['name' => $name]);
		$serial++;
		QFunc::updateField('serials', ['serial' => $serial], ['name' => $name]);
	}
}


class DC{

	public static function isExists($category, $type, $dcNumber){
		return (bool) QFunc::queryRows('dc_report', ['category' => $category, 'type' => $type, 'dcNumber' => $dcNumber]);
	}

	public static function findByID($dcID){
		$qData = QFunc::fetchRow('dc_report', true, ['id' => $dcID]);
		if(empty($qData)){
			return false;
		}

		return self::find($qData['category'], $qData['type'], $qData['dcNumber']);
	}

	public static function find($category, $type, $dcNumber){
		$rData = QFunc::fetchRow('dc_report', true, ['category' => $category, 'type' => $type, 'dcNumber' => $dcNumber]);
		if(empty($rData)){
			return false;
		}

		$newObj 				= new DC;
		$newObj->id 			= $rData['id'];
		$newObj->category 		= $rData['category'];
		$newObj->type 			= $rData['type'];
		$newObj->dcNumber 		= $rData['dcNumber'];
		$newObj->dcDate 		= $rData['dcDate'];
		$newObj->batchNumber 	= $rData['batchNumber'];
		$newObj->remarks 		= $rData['remarks'];
		
		$newObj->part1itemOrderID = $rData['part1itemOrderID'];
		$newObj->part2itemOrderID = $rData['part2itemOrderID'];
		$newObj->part3itemOrderID = $rData['part3itemOrderID'];
		$newObj->part4itemOrderID = $rData['part4itemOrderID'];
		$newObj->part5itemOrderID = $rData['part5itemOrderID'];
		
		$newObj->part1Qty = $rData['part1Qty'];
		$newObj->part2Qty = $rData['part2Qty'];
		$newObj->part3Qty = $rData['part3Qty'];
		$newObj->part4Qty = $rData['part4Qty'];
		$newObj->part5Qty = $rData['part5Qty'];

		
		$newObj->maxDays 	= $rData['maxDays'];
		$newObj->status 	= $rData['status'];
		$newObj->fileName 	= $rData['fileName'];
		$newObj->date 		= $rData['date'];


		$tableName 		= $newObj->category == 'GOODS'? 'purchase_order_goods' : 'purchase_order_service';
		$po 			= (object) QFunc::fetchRow($tableName, true, ['id' => $rData['poID']], 0);
		$newObj->po 	= $po;

		$supplier = (object) QFunc::fetchRow('supplier_master', true, ['id' => $po->supplierID]);
		$newObj->supplier = $supplier;

		if($newObj->part2Qty == NULL){
			$totalParts = 1;
		} else if($newObj->part3Qty == NULL){
			$totalParts = 2;
		} else if($newObj->part4Qty == NULL){
			$totalParts = 3;
		} else if($newObj->part5Qty == NULL){
			$totalParts = 4;
		} else {
			$totalParts = 5;
		}

		$newObj->totalParts = $totalParts;
		$tableItemOrder 	= $category == 'SERVICE'? 'item_order_service': 'item_order_goods';

		for($i = 1; $i <= $totalParts; $i++){
			$itemOrderID 		= 'part' . $i .'itemOrderID';
			$partID 			= 'part' . $i .'ID';

			$iPartID 			= QFunc::fetchField($tableItemOrder, 'partID', ['id' => $newObj->$itemOrderID]);
			$newObj->$partID 	= $iPartID;
		}

		
		$newObj->part1Name = partName($newObj->part1ID);
		$newObj->part1Price = $newObj->category == 'GOODS'? fetchItemOrderPriceGoods($rData['poID'], $newObj->part1ID) : fetchItemOrderPrice($rData['poID'], $newObj->part1ID);
		$newObj->part1TaxablePrice = 0;

		$part = Part::find($newObj->part1ID);
		$newObj->part = $part;

		return $newObj;
	}

	public static function reset($category, $type, $dcNumber){
		if(!self::isExists($category, $type, $dcNumber)){
			return false;
		}
	
		$tableItemOrder = $category == 'SERVICE'? 'item_order_service': 'item_order_goods';
		
		$dc = DC::find($category, $type, $dcNumber);
		if($dc->status != 'PENDING'){
			return false;
		}

		for($i = 1; $i <= $dc->totalParts; $i++){
			$iId 			= 'part'. $i .'itemOrderID';
			$iQty 			= 'part'. $i .'Qty';

			$itemOrderID 	= $dc->$iId;
			$issueQty 		= $dc->$iQty;
			
			$currentQty = QFunc::fetchField($tableItemOrder, 'qty', ['id' => $itemOrderID]);
			$theQty 	= $currentQty + $issueQty;
			QFunc::updateField($tableItemOrder, ['qty' => $theQty], ['id' => $itemOrderID]);
		}

		QFunc::updateField('dc_report', [
				'dcDate' 			=> NULL,
				'batchNumber' 		=> '',
				'remarks' 			=> '',
				'part1itemOrderID' 	=> NULL,
				'part2itemOrderID' 	=> NULL,
				'part3itemOrderID' 	=> NULL,
				'part4itemOrderID' 	=> NULL,
				'part5itemOrderID' 	=> NULL,
				'part1Qty' 			=> NULL,
				'part2Qty' 			=> NULL,
				'part3Qty' 			=> NULL,
				'part4Qty' 			=> NULL,
				'part5Qty' 			=> NULL,
				'maxDays' 			=> NULL,
				'status' 			=> 'RESET',
				'fileName' 			=> '',
			], 
			['id' => $dc->id]);

		QFunc::deleteRow('vendor_invoice', ['dcID' => $dc->id]);

		return true;
	}

	public static function isSupplierAvailable($supplierID){
		$poIDs 		= Supplier::poIDs($supplierID);
		$servicePOs = implode($poIDs['SERVICE'], 	',');
		$goodsPOs 	= implode($poIDs['GOODS'], 		',');

		$unclosedDC = QFunc::queryRows('dc_report', "status = 'PENDING' AND 
			((category = 'SERVICE' AND type != 'NORETURN' AND poID IN($servicePOs)) OR ((category = 'GOODS' AND type != 'NORETURN' AND poID IN($goodsPOs)))) AND 
			DATE_ADD(STR_TO_DATE(dcDate, '%d/%m/%Y'), INTERVAL maxDays DAY) < CURDATE() ");

		if($unclosedDC === 0){
			return true;
		}

		return false;
	}

	public static function extendDCDate($supplierID, $extendedDays){
		$poIDs 			= Supplier::poIDs($supplierID);
		$servicePOs 	= implode($poIDs['SERVICE'], 	',');
		$goodsPOs 		= implode($poIDs['GOODS'], 		',');

		$extendedDays 	= (int) $extendedDays;

		QFunc::updateField('dc_report', 
			['maxDays' => $extendedDays], 
			"((category = 'SERVICE' AND poID IN($servicePOs)) OR ((category = 'GOODS' AND poID IN($goodsPOs))))
			 AND status = 'PENDING' "
		);

		return true;
	}
}

class CloseDC{

	public static function close($dcID, $invoiceNumber, $type, $date, $part1Qty, $part2Qty, $part3Qty, $part4Qty, $part5Qty){

		$dc = DC::findByID($dcID);
		if(empty($dc)){
			return ['rCode' => 100, 'rMsg' => 'DC NOT FOUND.'];
		}

		if($dc->status == 'COMPLETE'){
			return 'DC ALREADY CLOSED.';
		}

		$flag = true;
		for($i = 1; $i <= $dc->totalParts; $i++){
			$partQty 		= 'part'.$i.'Qty';
			$totalQty 		= $dc->$partQty;
			$returnedQty 	= 0;

			$invoiceList 	= QFunc::fetchAssoc('vendor_invoice', true, ['dcID' => $dc->id]);
			foreach($invoiceList as $eachInvoice){
				$returnedQty = $returnedQty + $eachInvoice[$partQty];
			}

			$totalReturnQty = $returnedQty + ((int) $$partQty);

			if(!is_numeric($totalReturnQty) || $dc->$partQty < $totalReturnQty){
				$flag = false;
				break;
			}
		}

		if(!$flag){
			return 'INVALID QTY.';
		}

		QFunc::insertRow('vendor_invoice', [
			'dcID' 			=> $dcID,
			'invoiceNumber' => $invoiceNumber,
			'invoiceType' 	=> $type,
			'invoiceDate' 	=> $date,
			'part1Qty' 		=> $part1Qty,
			'part2Qty' 		=> $part2Qty,
			'part3Qty' 		=> $part3Qty,
			'part4Qty' 		=> $part4Qty,
			'part5Qty' 		=> $part5Qty,
			'status' 		=> 'OK'
		]);


		$flag = true;
		for($i = 1; $i <= $dc->totalParts; $i++){
			$partQty 		= 'part'.$i.'Qty';
			$totalQty 		= $dc->$partQty;
			$returnedQty 	= 0;

			$invoiceList 	= QFunc::fetchAssoc('vendor_invoice', true, ['dcID' => $dc->id]);
			foreach($invoiceList as $eachInvoice){
				$returnedQty = $returnedQty + $eachInvoice[$partQty];
			}

			if($dc->$partQty != $returnedQty){
				$flag = false;
				break;
			}
		}

		if($flag){
			QFunc::updateField('dc_report', ['status' => 'COMPLETE'], ['id' => $dc->id]);
			return 'DC COMPLETED.';
		}

		return true;
	}

}


class VendorInvoice{

	public static function findByDC($id){
		$rData = QFunc::fetchAssoc('vendor_invoice', true, ['dcID' => $id]);
		if(empty($rData)){
			return [];
		}

		$theArray = [];
		foreach($rData as $eachData){
			$theArray[] = self::find($eachData['id']);
		}

		return $theArray;
	}

	public static function find($id){
		$rData = QFunc::fetchRow('vendor_invoice', true, ['id' => $id]);
		if(empty($rData)){
			return false;
		}

		$newObj 				= new VendorInvoice;
		$newObj->id 			= $rData['id'];
		$newObj->dcID 			= $rData['dcID'];
		$newObj->invoiceNumber 	= $rData['invoiceNumber'];
		$newObj->invoiceType 	= $rData['invoiceType'];
		$newObj->invoiceDate 	= $rData['invoiceDate'];
		$newObj->part1Qty 		= $rData['part1Qty'];
		$newObj->part2Qty 		= $rData['part2Qty'];
		$newObj->part3Qty 		= $rData['part3Qty'];
		$newObj->part4Qty 		= $rData['part4Qty'];
		$newObj->part5Qty 		= $rData['part5Qty'];
		$newObj->status 		= $rData['status'];
		$newObj->date 			= $rData['date'];
		
		return $newObj;
	}
}

?>