<?php

	require 'class/QFunc.class.php';
	require 'class/class.inc.php';

	date_default_timezone_set("Asia/Kolkata");
	session_start();


	function isPost(...$funcArgs){
		$flag = true;

		for($i = 0; $i < count($funcArgs); $i++){
			if(!isset($_POST[$funcArgs[$i]])){
				$flag = false; break;
			}
		}

		return $flag;
	}

	function isGet(...$funcArgs){
		$flag = true;

		for($i = 0; $i < count($funcArgs); $i++){
			if(!isset($_GET[$funcArgs[$i]])){
				$flag = false; break;
			}
		}

		return $flag;
	}
	
	function post($var){
		return isset($_POST[$var])? ($_POST[$var]): null;
	}

	function get($var){
		return isset($_GET[$var])? ($_GET[$var]): null;
	}

	function dd($var){
		echo '<pre>'; print_r($var); exit;
	}

	function redirect($pageName){
		header("Location: $pageName "); exit;
	}

	function fetchPONumber($poID){
		global $con;
		return mysqli_query($con, "SELECT poNumber FROM purchase_order_service WHERE id = '$poID' ")->fetch_object()->poNumber;
	}

	function fetchPONumberGoods($poID){
		global $con;
		return mysqli_query($con, "SELECT poNumber FROM purchase_order_goods WHERE id = $poID ")->fetch_object()->poNumber;
	}

	function fetchPODate($poID){
		global $con;
		return mysqli_query($con, "SELECT poDate  FROM purchase_order_service WHERE id = '$poID' ")->fetch_object()->poDate;
	}

	function fetchPODateGoods($poID){
		global $con;
		return mysqli_query($con, "SELECT poDate FROM purchase_order_goods WHERE id = $poID ")->fetch_object()->poDate;
	}

	function fetchPOCompany($poID){
		global $con;
		return mysqli_query($con, "SELECT supplierID FROM purchase_order_service WHERE id = '$poID' ")->fetch_object()->supplierID;
	}


	
	function fetchPartNumber($partID){
		global $con;
		return mysqli_query($con, "SELECT number FROM part_master WHERE id = '$partID' ")->fetch_object()->number;
	}

	function fetchPartDesc($partID){
		global $con;
		return mysqli_query($con, "SELECT name FROM part_master WHERE id = '$partID' ")->fetch_object()->name;
	}

	function fetchPartCGST($partID){
		global $con;
		return mysqli_query($con, "SELECT cgst FROM part_master WHERE id = '$partID' ")->fetch_object()->cgst;
	}

	function fetchPartSGST($partID){
		global $con;
		return mysqli_query($con, "SELECT sgst FROM part_master WHERE id = '$partID' ")->fetch_object()->sgst;
	}

	function fetchPartIGST($partID){
		global $con;
		return mysqli_query($con, "SELECT igst FROM part_master WHERE id = '$partID' ")->fetch_object()->igst;
	}

	function fetchPartUGST($partID){
		global $con;
		return mysqli_query($con, "SELECT ugst FROM part_master WHERE id = '$partID' ")->fetch_object()->ugst;
	}

	function fetchPartTCS($partID){
		global $con;
		return mysqli_query($con, "SELECT tcs FROM part_master WHERE id = '$partID' ")->fetch_object()->tcs;
	}

	function fetchPartHSN($partID){
		global $con;
		return mysqli_query($con, "SELECT hsn FROM part_master WHERE id = '$partID' ")->fetch_object()->hsn;
	}

	function fetchPartUOM($partID){
		global $con;
		return mysqli_query($con, "SELECT uom FROM part_master WHERE id = '$partID' ")->fetch_object()->uom;
	}

	function fetchCustomerName($customerID){
		global $con;
		return mysqli_query($con, "SELECT name FROM supplier_master WHERE id = $customerID ")->fetch_object()->name;
	}

	function fetchSupplierName($supplierID){
		global $con;
		return mysqli_query($con, "SELECT name FROM supplier_master WHERE id = $supplierID ")->fetch_object()->name;
	}

	function fetchItemOrderPrice($poID, $partID){
		global $con;
		$row = mysqli_query($con, "SELECT price FROM item_master_service WHERE partID = $partID AND poID = $poID ")->fetch_object();
		if (isset($row->price)) {
			return $row->price;
		}
		return 0;
	}

	function fetchItemOrderPriceGoods($poID, $partID){
		global $con;
		$row = mysqli_query($con, "SELECT price FROM item_master_goods WHERE partID = $partID AND poID = $poID ")->fetch_object();
		if (isset($row->price)) {
			return $row->price;
		}
		return 0;
	}

	function partName($partID){
		return QFunc::fetchField('part_master', 'name', ['id' => $partID]);
	}

	function partNumber($partID){
		return QFunc::fetchField('part_master', 'number', ['id' => $partID]);
	}

	function xPercentageOfY (float $percentage, float $value): float {
		return ($value / 100) * $percentage;
	}



?>