<?php

class PendingDCReport{
	private $category;
	private $type;
    private $reportList;
    private $exportMode = true;
    private $errorFlag 	= false; 
	
	public function __construct($category, $type){
		$this->category 	= $category;
		$this->type 		= $type;
	}

	public function generateReport(){
		$this->listReport($this->category, $this->type);
		$this->exportReport();
	}

	private function listReport($category, $type){
		$whereClause = '';
		if($category != 'ALL'){
			$whereClause  = "AND category = '$category' ";
		}

		if($type != 'ALL'){
			$whereClause  .= " AND type = '$type' ";
		}
		
		$QdcList = QFunc::executeQuery("SELECT * FROM dc_report WHERE status = 'PENDING' $whereClause ORDER BY STR_TO_DATE(dcDate, '%d/%m/%Y') ASC ");

		$dcList 		= [];
		$dcReportList 	= [];
		
		while($row = mysqli_fetch_assoc($QdcList)){
			$dcList[] = $row;
		}

		for($i = 0; $i < count($dcList); $i++){

			for($j = 1; $j <= 5; $j++){
				$iItemOrderID 	= 'part'.$j.'itemOrderID';
				$iPartQty 		= 'part'.$j.'Qty';

				$itemOrderID 	= $dcList[$i][$iItemOrderID];
				$partQty 		= $dcList[$i][$iPartQty];
				$poID 			= $dcList[$i]['poID'];

				if($itemOrderID == NULL || $partQty == NULL){
					break;
				}

				$table_itemOrder 	= $dcList[$i]['category'] == 'SERVICE'? 'item_order_service': 'item_order_goods';
				$itemOrder 			= QFunc::fetchRow($table_itemOrder, true, ['id' => $itemOrderID]);

				$po 		= $dcList[$i]['category'] == 'SERVICE'? Service::findPO($poID): Goods::findPO($poID);
				$part 		= Part::find($itemOrder['partID']);
				$supplier 	= Supplier::find($po->supplierID);

				$receivedQty 	= 0;
				$qReceivedQty 	= QFunc::fetchAssoc('vendor_invoice', true, ['dcID' => $dcList[$i]['id']]);
				
				foreach($qReceivedQty as $eachQty){
					$receivedQty += $eachQty[$iPartQty];
				}

				$remainQty = $partQty - $receivedQty;

				$theArray 				= [];
				$theArray['DATE'] 		= $dcList[$i]['dcDate'];
				$theArray['DC NO'] 		= $dcList[$i]['dcNumber'];
				$theArray['CATEGORY'] 	= $dcList[$i]['category'];
				$theArray['TYPE'] 		= $dcList[$i]['type'];
				$theArray['SUPPLIER'] 	= $supplier->name;
				$theArray['PO NO'] 		= $po->poNumber;
				$theArray['PART NO'] 	= $part->number;
				$theArray['MATERIAL'] 	= $part->name;
				$theArray['SEND QTY'] 	= $partQty;
				$theArray['RECV QTY'] 	= $receivedQty;
				$theArray['BALANCE QTY']= $remainQty;

				$dcReportList[] 		= $theArray;
			}
		}

		$this->reportList = $dcReportList;
	}

	private function exportReport(){

		$reportList 	= $this->reportList;

		$columnTitles 	= [
				'DATE', 'DC NO', 'CATEGORY', 'TYPE', 'SUPPLIER', 'PO NO', 'PART NO', 'MATERIAL', 'SEND QTY', 'RECV QTY', 'BALANCE QTY'];
		$fileName 		= 'Pending DC Report_'.time();

		$objPHPExcel 	= new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Me")->setLastModifiedBy("Me")->setTitle("My Excel Sheet")->setSubject("My Excel Sheet")->setDescription("Excel Sheet")->setKeywords("Excel Sheet")->setCategory("Me");

		$objPHPExcel->setActiveSheetIndex(0);

		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(13);
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(12);
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
		$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);

		$columnAlpha = 'A';
		for($i = 0; $i < count($columnTitles); $i++, $columnAlpha++){
			$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.'1', $columnTitles[$i]);
		}

		for($i = 0; $i < count($reportList); $i++){
			$columnAlpha = 'A';
			for($j = 0; $j < count($columnTitles); $j++, $columnAlpha++){
				$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.($i + 2), $reportList[$i][$columnTitles[$j]]);
			}
		}

		$objPHPExcel->getActiveSheet()->setTitle($fileName);

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		
		if($this->exportMode){
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="' . $fileName . '.xlsx"');
			header('Cache-Control: max-age=0');
			$objWriter->save('php://output');
		} else {
			$objWriter->save('file/report/dc-pending/' . $fileName . '.xlsx');
			echo '<a href="file/report/dc-pending/'. $fileName .'.xlsx">Open Your Excel Document</a>'; exit;
		}
	}
}

?>