<?php

class StockReport{

	private $category;
	private $supplierID;
	private $fromDate;
	private $toDate;
	
	private $poIDs 			= [];
	private $dcIDs 			= [];
	private $partIDs 		= [];

	private $dcList 		= [];
	private $listByParts 	= [];
    private $reportList 	= [];

    private $exportMode  	= false;
    

	public function __construct($category, $supplierID, $fromDate, $toDate){
		$this->category 	= $category;
		$this->supplierID 	= $supplierID;
		$this->fromDate 	= $fromDate;
		$this->toDate 		= $toDate;

		$this->supplier 	= Supplier::find($supplierID);
		$companyID 			= QFunc::fetchField('company_master', 'id');
		$this->company 		= Company::find($companyID);

		$this->generateReport();
	}

	public function generateReport(){
		$this->fetchPO();
		$this->fetchList();
		$this->listByParts();
		$this->reportList();
		$this->exportReport();
	}

	public function fetchPO(){
		$poTable 	= $this->category == 'SERVICE'? 'purchase_order_service': 'purchase_order_goods';
		$qPOIDs 	= QFunc::fetchAssoc($poTable, true, ['supplierID' => $this->supplierID]);
		$poIDs 		= [];
		foreach($qPOIDs as $poID){
			$poIDs[] = $poID['id'];
		}

		$this->poIDs = $poIDs;
	}

	private function fetchList(){
		
		if(count($this->poIDs) == 0){ return 0; }

		$poIDstr 	= implode(',', $this->poIDs);
		$qDC 		= QFunc::executeQuery(
				"SELECT * FROM dc_report WHERE category = '{$this->category}' AND poID IN ($poIDstr) AND STR_TO_DATE(dcDate, '%d/%m/%Y') >= STR_TO_DATE('{$this->fromDate}', '%d/%m/%Y') AND STR_TO_DATE(dcDate, '%d/%m/%Y') <= STR_TO_DATE('{$this->toDate}', '%d/%m/%Y') AND status IN('PENDING', 'COMPLETE') ORDER BY STR_TO_DATE(dcDate, '%d/%m/%Y') ");
				// "SELECT * FROM dc_report WHERE category = '{$this->category}' AND poID IN ($poIDstr) AND (STR_TO_DATE(dcDate, '%d/%m/%Y') >= DATE_FORMAT(NOW(), '%Y-%m-01') AND status IN('PENDING', 'COMPLETE')) ORDER BY STR_TO_DATE(dcDate, '%d/%m/%Y') ASC ");

		while($row = mysqli_fetch_assoc($qDC)){
			$this->dcList[] = DC::findByID($row['id']);
		}

		$partIDs = [];
		foreach($this->dcList as $eachDC){
			$this->dcIDs[] = $eachDC->id;

			for($i = 1; $i <= $eachDC->totalParts; $i++){
				$i_PartID = 'part'.$i.'ID';
				$partIDs[] = $eachDC->$i_PartID;
			}
		}

		$this->partIDs = array_values(array_unique($partIDs));
	}

	private function listByParts(){
		$listAlpha = [];

		for($i = 0; $i < count($this->dcList); $i++){
			$dc = $this->dcList[$i];

			for($j = 1; $j <= $dc->totalParts; $j++){
				$partQty 	= 'part'.$j.'Qty';
				$partID 	= 'part'.$j.'ID';

				$ji_List 				= [];
				$ji_List['dcID'] 		= $dc->id;
				$ji_List['category'] 	= $dc->category;
				$ji_List['type'] 		= $dc->type;
				$ji_List['dcNumber'] 	= $dc->dcNumber;
				$ji_List['dcDate'] 		= $dc->dcDate;
				$ji_List['sentQty'] 	= $dc->$partQty;
				$ji_List['partID'] 		= $dc->$partID;
				$invoices 				= VendorInvoice::findByDC($this->dcList[$i]->id);
				
				$jj_List 	= [];
				$k_thisQty 	= 0;
				for($k = 0; $k < count($invoices); $k++){
					$invoice 					= $invoices[$k];
					
					if($invoice->$partQty == NULL || $invoice->$partQty == 0){ 
						continue; 
					}
					
					$k_thisQty 					+= $invoice->$partQty;

					$ki_List['invoiceID'] 		= $invoice->id;
					$ki_List['dcID'] 			= $invoice->dcID;
					$ki_List['invoiceNumber'] 	= $invoice->invoiceNumber;
					$ki_List['invoiceType'] 	= $invoice->invoiceType;
					$ki_List['invoiceDate'] 	= $invoice->invoiceDate;
					$ki_List['receivedQty'] 	= $invoice->invoiceType == 'DESPATCH'? 	$invoice->$partQty: 0;
					$ki_List['rejectedQty'] 	= $invoice->invoiceType == 'REJECT'? 	$invoice->$partQty: 0;
					$ki_List['balanceQty'] 		= $dc->$partQty - $k_thisQty;
					$ki_List['status'] 			= ($dc->$partQty - $k_thisQty) == 0? 'CLOSED': 'OPEN';
					$jj_List[] = $ki_List;
				}

				$this->listByParts[$dc->$partID][] = ['DC' => $ji_List, 'INVOICE' => $jj_List];
			}
		}
	}

	public function reportList(){
		$theArray = [];
		for($i = 0; $i < count($this->partIDs); $i++){
			$part 							= Part::find($this->partIDs[$i]);
			
			$i_theArray 					= [];
			$i_theArray['PART NAME'] 		= $part->name;
			$i_theArray['PART NO'] 			= $part->number;
			$i_theArray['PART ID'] 			= $part->id;
			$i_theArray['totalSentQty'] 	= 0;
			$i_theArray['totalReceivedQty'] = 0;
			$i_theArray['totalRejectedQty'] = 0;
			
			$i_Row 		= [];
			for($j = 0, $jRow = 0; $j < count($this->listByParts[$part->id]); $j++){
				$thisPart 	= $this->listByParts[$part->id][$j];
				
				$i_Row[$jRow]['S NO'] 				= $j + 1;
				$i_Row[$jRow]['DC DATE'] 			= $thisPart['DC']['dcDate'];
				$i_Row[$jRow]['DC NO'] 				= $thisPart['DC']['dcNumber'];
				$i_Row[$jRow]['PART NAME'] 			= $part->name;
				$i_Row[$jRow]['PART NO'] 			= $part->number;
				$i_Row[$jRow]['SENT QTY'] 			= $thisPart['DC']['sentQty'];
				$i_theArray['totalSentQty'] 	   += $thisPart['DC']['sentQty'];

				
				if(count($thisPart['INVOICE']) == 0){
					$i_Row[$jRow]['DATE'] 				= '';
					$i_Row[$jRow]['INVOICE NO'] 		= '';
					$i_Row[$jRow]['RECEIVED QTY'] 		= '';
					$i_Row[$jRow]['REJECTED QTY'] 		= '';
					$i_Row[$jRow]['BALANCE'] 			= $thisPart['DC']['sentQty'];
					$i_Row[$jRow]['CHALLAN STATUS'] 	= 'OPEN';

					$jRow++;

				} else {
					for($k = 0; $k < count($thisPart['INVOICE']); $k++){
						$thisInvoice = $thisPart['INVOICE'][$k];

						if($k > 0){
							$i_Row[$jRow]['S NO'] 			= '';
							$i_Row[$jRow]['DC DATE'] 		= '';
							$i_Row[$jRow]['DC NO'] 			= '';
							$i_Row[$jRow]['PART NAME'] 		= '';
							$i_Row[$jRow]['PART NO'] 		= '';
							$i_Row[$jRow]['SENT QTY'] 		= '';
						}

						$i_Row[$jRow]['DATE'] 				= $thisInvoice['invoiceDate'];
						$i_Row[$jRow]['INVOICE NO'] 		= $thisInvoice['invoiceNumber'];
						$i_Row[$jRow]['RECEIVED QTY'] 		= $thisInvoice['receivedQty'];
						$i_Row[$jRow]['REJECTED QTY'] 		= $thisInvoice['rejectedQty'];
						$i_Row[$jRow]['BALANCE'] 			= $thisInvoice['balanceQty'];
						$i_Row[$jRow]['CHALLAN STATUS'] 	= $thisInvoice['status'];
						
						$i_theArray['totalReceivedQty']    += $thisInvoice['receivedQty'];
						$i_theArray['totalRejectedQty']    += $thisInvoice['rejectedQty'];
						$jRow++;
					}
				}

				$i_Row[$jRow]['S NO'] 			= '';
				$i_Row[$jRow]['DC DATE'] 		= '';
				$i_Row[$jRow]['DC NO'] 			= '';
				$i_Row[$jRow]['PART NAME'] 		= '';
				$i_Row[$jRow]['PART NO'] 		= '';
				$i_Row[$jRow]['SENT QTY'] 		= '';
				$i_Row[$jRow]['DATE'] 			= '';
				$i_Row[$jRow]['INVOICE NO'] 	= '';
				$i_Row[$jRow]['RECEIVED QTY'] 	= '';
				$i_Row[$jRow]['REJECTED QTY'] 	= '';
				$i_Row[$jRow]['BALANCE'] 		= '';
				$i_Row[$jRow]['CHALLAN STATUS'] = '';
				$jRow++;
			}

			$i_theArray['DATA'] 			= $i_Row;
			$i_theArray['totalBalanceQty'] 	= $i_theArray['totalSentQty'] - (
					$i_theArray['totalReceivedQty'] + $i_theArray['totalRejectedQty']);
			
			$theArray[] 					= $i_theArray;
		}

		$this->reportList = $theArray;
	}

	public function exportReport(){
		$reportList 	= $this->reportList;

		$columnTitles 	= [
				'S NO', 'DC DATE', 'DC NO', 'PART NAME', 'PART NO', 'SENT QTY', 'DATE', 'INVOICE NO', 'RECEIVED QTY', 'REJECTED QTY', 'BALANCE', 'CHALLAN STATUS'];
		$fileName 		= 'Supplier Report_'.time();

		$objPHPExcel 	= new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Me")->setLastModifiedBy("Me")->setTitle("My Excel Sheet")->setSubject("My Excel Sheet")->setDescription("Excel Sheet")->setKeywords("Excel Sheet")->setCategory("Me");

		$centerStyle = array(
	        'alignment' => array(
	            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
	            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
	        )
	    );

		$bgRed = ['fill' => [	'type' 	=> PHPExcel_Style_Fill::FILL_SOLID,
								'color' => ['rgb' => 'FF2121']]
		];

		$bgGreen = ['fill' => [	'type' 	=> PHPExcel_Style_Fill::FILL_SOLID,
								'color' => ['rgb' => '00CC00']]
		];

		$bgYellow = ['fill' => ['type' 	=> PHPExcel_Style_Fill::FILL_SOLID,
								'color' => ['rgb' => 'FFFF00']]
		];

		$bgGray = ['fill' => ['type' 	=> PHPExcel_Style_Fill::FILL_SOLID,
								'color' => ['rgb' => 'CCCCCC']]
		];
		
		for($i = 0; $i < count($this->reportList); $i++){
			$thisPart = $this->reportList[$i];
			$objPHPExcel->createSheet($i);
			$objPHPExcel->setActiveSheetIndex($i);
			$sheetTitle = preg_replace('~[^A-Za-z0-9- ]+~', '', $thisPart['PART NO']);
			$objPHPExcel->getActiveSheet()->setTitle($sheetTitle);
			
			$objPHPExcel->getActiveSheet()->getDefaultStyle()->getFont()->setSize(11);
			$objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(22);

			$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
			$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(13);
			$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
			$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(12);
			$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
			$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
			$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(17);

			$objPHPExcel->getActiveSheet()->mergeCells('A1:C1');
			$objPHPExcel->getActiveSheet()->mergeCells('A2:C2');
			$objPHPExcel->getActiveSheet()->mergeCells('A3:C3');
			
			$objPHPExcel->getActiveSheet()->setCellValue('A2', 'PART NAME : '. $thisPart['PART NAME']);
			$objPHPExcel->getActiveSheet()->setCellValue('A3', 'PART NO : '. $thisPart['PART NO']);
		
			$objPHPExcel->getActiveSheet()->mergeCells('D1:L3');
			$objPHPExcel->getActiveSheet()->getStyle('D1:L3')->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->setCellValue('D1', 'STOCK STATEMENT MONTH OF '. strtoupper(date('F - Y')));
			$objPHPExcel->getActiveSheet()->getStyle('D1')->getFont()->setSize(14);

			$objPHPExcel->getActiveSheet()->mergeCells('A4:F4');
			$objPHPExcel->getActiveSheet()->mergeCells('G4:L4');
			$objPHPExcel->getActiveSheet()->getStyle('A4:F4')->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->getStyle('G4:L4')->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->setCellValue('A4', $this->company->name);
			$objPHPExcel->getActiveSheet()->setCellValue('G4', $this->supplier->name);
			$objPHPExcel->getActiveSheet()->getStyle('A4')->getFont()->setSize(13)->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('G4')->getFont()->setSize(13)->setBold(true);
			
			$columnAlpha = 'A';
			for($j = 0; $j < count($columnTitles); $j++, $columnAlpha++){
				$objPHPExcel->getActiveSheet()->setCellValue($columnAlpha.'5', $columnTitles[$j]);
				$objPHPExcel->getActiveSheet()->getStyle($columnAlpha.'5')->applyFromArray($centerStyle);
				$objPHPExcel->getActiveSheet()->getStyle($columnAlpha.'5')->applyFromArray($bgGray);
			}

			$rowNumber = 6;
			for($j = 0; $j < count($thisPart['DATA']); $j++, $rowNumber++){
				$thisData 		= $thisPart['DATA'][$j];
				$columnName 	= 'A';
				
				for($k = 0; $k < count($columnTitles); $k++, $columnName++){
					$objPHPExcel->getActiveSheet()->setCellValue($columnName.$rowNumber, $thisData[$columnTitles[$k]]);
					$objPHPExcel->getActiveSheet()->getStyle($columnName.$rowNumber)->applyFromArray($centerStyle);
				}
			}

			$objPHPExcel->getActiveSheet()->mergeCells('A'.$rowNumber.':E'.$rowNumber);
			$objPHPExcel->getActiveSheet()->mergeCells('G'.$rowNumber.':H'.$rowNumber);
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$rowNumber, 'Total Sent Qty');
			$objPHPExcel->getActiveSheet()->setCellValue('G'.$rowNumber, 'Total Received');
			$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->getStyle('G'.$rowNumber)->applyFromArray($centerStyle);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$rowNumber)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('G'.$rowNumber)->getFont()->setBold(true);

			$objPHPExcel->getActiveSheet()->setCellValue('F'.$rowNumber, $thisPart['totalSentQty']);
			$objPHPExcel->getActiveSheet()->setCellValue('I'.$rowNumber, $thisPart['totalReceivedQty']);
			$objPHPExcel->getActiveSheet()->setCellValue('J'.$rowNumber, $thisPart['totalRejectedQty']);
			$objPHPExcel->getActiveSheet()->setCellValue('K'.$rowNumber, $thisPart['totalBalanceQty']);

			$objPHPExcel->getActiveSheet()->getStyle('F'.$rowNumber)->applyFromArray($bgGreen);
			$objPHPExcel->getActiveSheet()->getStyle('I'.$rowNumber)->applyFromArray($bgGreen);
			$objPHPExcel->getActiveSheet()->getStyle('J'.$rowNumber)->applyFromArray($bgRed);
			$objPHPExcel->getActiveSheet()->getStyle('K'.$rowNumber)->applyFromArray($bgYellow);

			$objPHPExcel->getActiveSheet()->freezePane('M6');
			
		}

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		
		if($this->exportMode){
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header('Content-Disposition: attachment;filename="' . $fileName . '.xlsx"');
			header('Cache-Control: max-age=0');
			$objWriter->save('php://output');
		} else {
			$objWriter->save('file/report/dc-supplier/' . $fileName . '.xlsx');
			echo '<a href="file/report/dc-supplier/'. $fileName .'.xlsx">Open Your Excel Document</a>'; exit;
		}
	}

}

?>