<?php
// Include autoloader
require_once 'autoload.inc.php';

// Reference the Dompdf namespace
use Dompdf\Dompdf;

require __DIR__.'/../core.inc.php';

error_reporting(0);
if($_SERVER['REQUEST_METHOD'] != 'POST'){
	echo 'No data'; exit;
}

$dcNumber 			= post('dcNumber');
$dcDate 			= post('dcDate');
$maxDays 			= post('maxDays');

$trigger 			= post('trigger');
$category 			= post('category');
$type 				= post('type');
$saveMode 			= post('saveMode');

$companyID 			= post('companyID');
$poID 				= post('poID');
$date 				= post('date');
$heatBatchNumber 	= post('heatBatchNumber');
$remarks 			= post('remarks');

$company 			= Company::find($companyID);
$po 				= $category == 'SERVICE'? Service::findPO($poID): Goods::findPO($poID);
$supplier 			= Supplier::find($po->supplierID);

for($i = 1, $totalParts = 0; $i <= 5; $i++, $totalParts++){
	$var1 = 'part'.$i;
	$var2 = $var1.'itemOrderID';
	$var3 = $var1.'Qty';

	if(isPost($var2) && isPost($var3) && post($var2) > 0 && post($var3) > 0){
		$$var2 			= post($var2);
		$$var3 			= post($var3);	
		$$var1 			= DCPart::find($category, $$var2, $$var3);
		$$var1->serial 	= $i;
		$part 			= $$var1;
		
		if($part->issueQty > $part->currentQty || !is_numeric($part->issueQty)){
			$totalParts = 0; break;
		}
	} else {
		break;
	}
}

if($totalParts == 0){
	echo 'No Parts Selected'; exit;
}

if($totalParts > 5){
	echo 'You cannot add more than 5 parts.'; exit;
}

if($saveMode == 'NEW' && DC::isExists($category, $type, $dcNumber)){
	redirect('../dc-result.php?status=Error&dcNumber='. $dcNumber .'&trigger='. $trigger .'&msg=DC already exists.');
}

if($saveMode == 'EDIT' && !DC::isExists($category, $type, $dcNumber)){
	redirect('../dc-result.php?status=Error&dcNumber='. $dcNumber .'&trigger='. $trigger .'&msg=DC not found.');
}

if(!DC::isSupplierAvailable($supplier->id)){
	redirect('../dc-result.php?status=Error&supplierName='. $supplier->name .'&trigger='. $trigger .'&msg=This supplier has some unclosed DC.');
}

for($i = 1; $i <= 5; $i++){
	$var 		= 'part'.$i;
	$var1 		= 'iPart'.$i;

	if(!isset($$var) || $i > $totalParts){
		$$var1 					= new StdClass();
		$$var1->serial 			= '&nbsp;';
		$$var1->name 			= '';
		$$var1->issueQty 		= '';
		$$var1->price 			= '';
		$$var1->value 			= '';
		$$var1->cgst 			= '';
		$$var1->sgst 			= '';
		$$var1->igst 			= '';
		$$var1->cgstPrice 		= '';
		$$var1->sgstPrice 		= '';
		$$var1->igstPrice 		= '';
		$$var1->hsn 			= '';
		$$var1->uom 			= '';
		$$var1->heatBatchNumber = '';
		$$var1->remarks 		= '';
	} else {
		$$var1 					= $$var;
		$$var1->heatBatchNumber = $heatBatchNumber;
		$$var1->remarks 		= $remarks;
	}
}

$tableItemOrder = $category == 'SERVICE'? 'item_order_service': 'item_order_goods';
$htmlFile 		= $category == 'SERVICE'? 'service-dc-pdf-html.php': 'goods-dc-pdf-html.php';

switch($trigger){
	case 'service-dc-jobwork': 	
		$dcTitle 	= 'JOB WORK DELIVERY NOTE'; 		
		$dcNote 	= '1. Sent for further processing and return. No Sales Involved.<br />
						2. Mention our JDN number and Heat number in your DC along with material.<br />'; 		
		break;
	
	case 'service-dc-return': 	
		$dcTitle 	= 'RETURNABLE DELIVERY NOTE'; 		
		$dcNote 	= '1. Sent for further processing and return. No Sales Involved.<br />
						2. Mention our RDN number and Heat number in your DC along with material.<br />'; 		
		break;
	
	case 'service-dc-noreturn': 
		$dcTitle 	= 'NON RETURNABLE DELIVERY NOTE'; 	
		$dcNote 	= '&nbsp;<br />&nbsp;<br />'; 		
		break;

	case 'goods-dc-jobwork': 	
		$dcTitle 	= 'JOB WORK DELIVERY NOTE'; 		
		$dcNote 	= '1. Sent for further processing and return. No Sales Involved.<br />
						2. Mention our JDN number and Heat number in your DC along with material.<br />'; 		
		break;
	
	case 'goods-dc-return': 	
		$dcTitle 	= 'RETURNABLE DELIVERY NOTE'; 		
		$dcNote 	= '1. Sent for further processing and return. No Sales Involved.<br />
						2. Mention our RDN number and Heat number in your DC along with material.<br />'; 		
		break;
	
	case 'goods-dc-noreturn': 	
		$dcTitle 	= 'NON RETURNABLE DELIVERY NOTE'; 	
		$dcNote 	= '&nbsp;<br />&nbsp;<br />'; 		
		break;
}


//Save PDF
include $htmlFile;
//echo $html; exit;
$fileName  		= 'DC '. str_replace('/', '-', $dcNumber) .'_'. time() .'.pdf';
$dompdf 		= new DOMPDF();
$dompdf->set_option('enable_html5_parser', TRUE);
$dompdf->load_html($html);
$dompdf->render();

$pdfContent 	= $dompdf->output();
file_put_contents('../DC/'. $trigger .'/'. $fileName, $pdfContent);

//Update Item Order Service Qty for each parts
for($i = 1; $i <= $totalParts; $i++){
	$var 		= 'part'.$i;
	$part 		= $$var;
	$remainQty 	= $part->currentQty - $part->issueQty;
	
	QFunc::updateField($tableItemOrder, 
		['qty' 	=> $remainQty], 
		['id' 	=> $part->itemOrderID]
	);
}


//Create Variable to save
for($i = 1; $i <= 5; $i++){
	$var1 = 'part'.$i;
	$var2 = $var1.'itemOrderID';
	$var3 = $var1.'Qty';

	if($i <= $totalParts){
		$$var2 = $$var1->itemOrderID;
		$$var3 = $$var1->issueQty;
	} else {
		$$var2 = null;
		$$var3 = null;
	}
}

$status 	= $type == 'NORETURN'? 'NORETURN': 'PENDING';
$maxDays 	= $type == 'NORETURN'? NULL: $maxDays;

if($saveMode == 'NEW'){
	QFunc::insertRow('dc_report', [
		'category' 			=> $category,
		'type' 				=> $type,
		'poID'				=> $poID,
		'dcNumber' 			=> $dcNumber,
		'dcDate' 			=> $dcDate,
		'batchNumber' 		=> $heatBatchNumber,
		'remarks' 			=> $remarks,
		'part1itemOrderID' 	=> $part1itemOrderID,
		'part2itemOrderID' 	=> $part2itemOrderID,
		'part3itemOrderID' 	=> $part3itemOrderID,
		'part4itemOrderID' 	=> $part4itemOrderID,
		'part5itemOrderID' 	=> $part5itemOrderID,
		'part1Qty' 			=> $part1Qty,
		'part2Qty' 			=> $part2Qty,
		'part3Qty' 			=> $part3Qty,
		'part4Qty' 			=> $part4Qty,
		'part5Qty' 			=> $part5Qty,
		'maxDays'			=> $maxDays,
		'status' 			=> $status,
		'fileName' 			=> $fileName
	]);

	Serial::increment($trigger);
}

if($saveMode == 'EDIT'){
	QFunc::updateField('dc_report', [
			'poID'				=> $poID,
			'dcDate' 			=> $dcDate,
			'batchNumber' 		=> $heatBatchNumber,
			'remarks' 			=> $remarks,
			'part1itemOrderID' 	=> $part1itemOrderID,
			'part2itemOrderID' 	=> $part2itemOrderID,
			'part3itemOrderID' 	=> $part3itemOrderID,
			'part4itemOrderID' 	=> $part4itemOrderID,
			'part5itemOrderID' 	=> $part5itemOrderID,
			'part1Qty' 			=> $part1Qty,
			'part2Qty' 			=> $part2Qty,
			'part3Qty' 			=> $part3Qty,
			'part4Qty' 			=> $part4Qty,
			'part5Qty' 			=> $part5Qty,
			'maxDays'			=> $maxDays,
			'status' 			=> $status,
			'fileName' 			=> $fileName
		], ['category' => $category, 'type' => $type, 'dcNumber' => $dcNumber]);
}


redirect('../dc-result.php?status=Success&dcNumber='. $dcNumber .'&file=' . $fileName .'&trigger='.$trigger);

?>