<?php
// Include autoloader
require_once 'autoload.inc.php';

// Reference the Dompdf namespace
use Dompdf\Dompdf;

require __DIR__.'/../core.inc.php';

require 'DCReport.class.php';
require '../class/DCReportIO.class.php';
require 'PendingDCReport.class.php';
require 'StockReport.class.php';
require 'PHPExcel-1.8/Classes/PHPExcel/IOFactory.php';

error_reporting(E_ALL);
if($_SERVER['REQUEST_METHOD'] != 'POST'){
	echo 'No data'; exit;
}

if (isPost('ioDCReport')) {
    $category       = post('category');
    $type           = post('type');
    $fromDate       = post('fromDate');
    $toDate         = post('toDate');
    
    $dcReport    	= new DCReportIO($category, $type, $fromDate, $toDate);
    $dcReport->generateReport();
}


if(isPost('dcReport')){
    $category       = post('category');
    $type       	= post('type');
    $fromDate       = post('fromDate');
    $toDate         = post('toDate');
    
    $dcReport    	= new DCReport($category, $type, $fromDate, $toDate);
    $dcReport->generateReport();
}


if(isPost('pendingDCReport')){
    $category       = post('category');
    $type       	= post('type');
    
    $dcReport    	= new PendingDCReport($category, $type);
    $dcReport->generateReport();
}

if(isPost('stockDCReport')){
	$category = post('category');
    $supplierID = post('supplierID');
    $fromDate = post('fromDate');
	$toDate = post('toDate');

	$stockReport = new StockReport($category, $supplierID, $fromDate, $toDate);
}


?>